% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_simulation.R
\name{gsimR}
\alias{gsimR}
\title{Simulate Genetic Data Based on Given Parameters}
\usage{
gsimR(Glist = NULL, h2 = NULL, m = NULL, prp.cau = NULL, n = NULL)
}
\arguments{
\item{Glist}{A list containing genetic data. If NULL, the function will stop with an error.}

\item{h2}{Heritability. If NULL, heritability of 0.5 is assumed.}

\item{m}{Number of causal markers. The values for either `m` or `prp.cau` should be provided at any given time. 
If the list of quality controlled markers is not available then list of raw markers is used.  
If `m` is NULL and `prp.cau` is also NULL, `prp.cau` will default to 0.001.}

\item{prp.cau}{Proportion of causal markers. The values for either `m` or `prp.cau` should be provided at any given time.}

\item{n}{Number of individuals randomly sampled from `Glist`. If NULL, all the individuals on `Glist` is used.}
}
\value{
A list containing:
\itemize{
  \item \code{y}: Vector of simulated phenotypes.
  \item \code{g}: Vector of simulated genetic values.
  \item \code{e}: Vector of simulated residual effects.
  \item \code{b}: list of vectors for effect sizes of the simulated causal markers in three classes.
  \item \code{causal}: list of vectors for ids for the simulated causal markers in three classes.
  \item \code{h2}: Estimated heritability of the simulated phenotype.
}
}
\description{
This function simulates phenotype data by random sampling of markers available on `Glist`.
Default parameters for the simulated phenotype reflect the genetic architecture assumed by BayesR prior(Erbe et al., 2012).
Marker effect are sampled from mixture distributions leading to small, moderate and large effect sizes. 
This function is under active development.
}
\author{
Peter Soerensen

Merina Shrestha
}
\keyword{internal}
