% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_SAI.R
\name{compute_SAI}
\alias{compute_SAI}
\title{Estimates seasonal-ageing indexes from  quarterly tables of crude rates estimates.}
\usage{
compute_SAI(x, y, ..., margins = FALSE, min.age = 0, max.age = 100)
}
\arguments{
\item{x}{A data.frame/list output of either \code{\link{crude_mx}}, \code{\link{crude_mx_sh2}} or \code{\link{crude_mx_sh3}} functions corresponding to a period (typically a year).}

\item{y}{A data.frame/list output of either \code{\link{crude_mx}}, \code{\link{crude_mx_sh2}} or \code{\link{crude_mx_sh3}} functions corresponding to another period (typically a different year than the one corresponding to `x`).}

\item{...}{Further output(s) of either \code{\link{crude_mx}}, \code{\link{crude_mx_sh2}} or \code{\link{crude_mx_sh3}} functions corresponding to another period(s) (typically different year(s) than the ones corresponding to `x` and `y`).}

\item{margins}{A `TRUE/FALSE` argument informing whether or not the marginal seasonal and ageing indexes should be also
computed. Default, `FALSE`.}

\item{min.age}{A non-negative integer informing about the initial minimal age for which SAIs must be computed. This minimum age can
be increased depending on the ages for which there are crude mx estimates (exposed-at-risk) in the objects  `x`, `y`, `...`. Default, 0.}

\item{max.age}{A positive integer informing about the initial maximum age for which SAIs must be computed. This maximum age can
be decreased depending on the maximum ages for which there are crude mx estimates (exposed-at-risk) in the objects  `x`, `y`, `...`.
Default, 100.}
}
\value{
When `margins = FALSE` a data frame with the (raw, normalized and linearized) estimated seasonal-ageing
indexes (SAI) corresponding to the set of integer ages determined by `min.age` and `max.age` and the exposed-at-risk
in the mx crude estimates for each combination of age and calendar quarter.
The data frame has the following components:
   \item{age}{ Integer age to which the SAIs corresponds.}
   \item{quarter.age}{ Age quarter to which the SAIs corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the SAIs corresponds.}
   \item{SAI.raw}{ Estimates of raw seasonal-ageing indexes for each combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{SAI.norm}{ Estimates of seasonal-ageing indexes, attained after normalizing raw SAIs estimates, for each  combination of `age`, `quarter.age` and `quarter.calendar`.}
   \item{SAI.lin}{ Final estimates of seasonal-ageing indexes, attained after linearizing normalized SAIs estimates,  for each combination of `age`, `quarter.age` and `quarter.calendar`.}
When `margins = TRUE` the output is a list with three data frames `SAI`, `SAI.age` and `SAI.quarter`.
`SAI` is defined as just described above. `SAI.age` and  `SAI.quarter` contains, in a similar vein than `SAI`,
the estimated marginal SAIs, corresponding to, respectively, the age quarter and the calendar (time, season)
quarter.
}
\description{
Given a set of quarterly tables of crude rates estimates corresponding to several years (periods),
              this function computes their corresponding seasonal-ageing indexes.
}
\examples{
\donttest{
# This can take a while
 t.stock <- time_exposed_stock(pop_2006$date.birth, 2006, "forward")
 t.stock <- t.stock[t.stock$age <= 100, ]
 temp <- quarterly_variables(death_2006$date.birth, death_2006$date.death)
 e.death <- count_events_quarter(temp)
 e.death <- e.death[e.death$age <= 100, ]
 t.birth <- time_exposed_newborns(birth_2006$date.birth)
 out <- crude_mx(t.stock, e.death, time.birth = t.birth)
 SAI.example <- compute_SAI(out, out)
}

# Fast example
dates.b <- c("2017-05-13", "2018-04-12", "2018-12-01")
t.stock <- time_exposed_stock(dates.b, year = 2020, type = "backward")
dates.bd <- c("2018-04-12")
dates.d <- c("2020-05-23")
x <- quarterly_variables(dates.bd, dates.d)
e.death <- count_events_quarter(x)
t.death <- time_exposed_outs(x)
out <- crude_mx(t.stock, e.death, t.death)
SAI.example <- compute_SAI(out, out)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}

Pavia, JM and Lledo, J (2025). qlifetable: An R package for constructing quarterly life tables. *PLoS ONE*, 20(2), e0315937. \doi{10.1371/journal.pone.0315937}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
