% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DunnettGLMPower.R
\name{Dunnett.GLM.power}
\alias{Dunnett.GLM.power}
\title{Dunnett.GLM power}
\usage{
Dunnett.GLM.power(
  groups,
  counts,
  control.name = NULL,
  alpha = 0.05,
  bootstrap.runs = 200,
  use.fixed.random.seed = NULL,
  Dunnett.GLM.zero.treatment.action = "log(x+1)",
  show.progress = TRUE,
  show.results = TRUE
)
}
\arguments{
\item{groups}{Group vector}

\item{counts}{Vector with count data}

\item{control.name}{Character string with control group name (optional)}

\item{alpha}{Significance level}

\item{bootstrap.runs}{Number of bootstrap runs}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{Dunnett.GLM.zero.treatment.action}{GLM.Dunnett method to be used for treatments only containing zeros}

\item{show.progress}{Show progress for each shift of lambda}

\item{show.results}{Show results}
}
\value{
Data frame with results from power analysis
}
\description{
The basic idea of Dunnett.GLM power calculations is to do parametric bootstrapping
for each dose/concentration group and to evaluate the proportion of results significantly different from the control.
}
\examples{
Daphnia.counts	# example data provided alongside the package

# Test Dunnett.GLM power
Dunnett.GLM.power(groups = Daphnia.counts$Concentration,
	counts = Daphnia.counts$Number_Young,
	control.name = NULL,
	alpha = 0.05,
	bootstrap.runs = 10,	# Caution: low number of bootstrap runs for testing
	use.fixed.random.seed = 123,  #fixed seed for reproducible results
	Dunnett.GLM.zero.treatment.action = "log(x+1)",
	show.progress = TRUE,
	show.results = TRUE)
}
