% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical_slice_multivariate.R
\name{slice_elliptical_mv}
\alias{slice_elliptical_mv}
\title{Multivariate Elliptical Slice Sampler}
\usage{
slice_elliptical_mv(x, log_target, mu, Sig, is_chol = FALSE)
}
\arguments{
\item{x}{The current state (as a numeric scalar).}

\item{log_target}{A function taking numeric scalar that evaluates the
(potentially unnormalized) log-target density, returning a numeric scalar.}

\item{mu}{Numeric vector with the mean of the supporting normal distribution.}

\item{Sig}{Positive definite covariance matrix. Alternatively, a
lower-triangular matrix with the Cholesky factor of the covariance matrix
(for faster computation).}

\item{is_chol}{Logical, is the supplied \code{Sig} in Cholesky (lower triangular) format? Default is false.}
}
\value{
A list with two elements:

\code{x} is the new state.

\code{nEvaluations} is the number of evaluations of the target function used to obtain the new
state.
}
\description{
Algorithm 1 of Nishihara et al. (2014) of the
elliptical slice sampler of Murray et al. (2010).
}
\examples{
lf <- function(x) dbeta(x[1], 3, 4, log = TRUE) + dbeta(x[2], 5, 3, log = TRUE)
n_iter <- 10 # set to 1e3 for more complete illustration
draws <- matrix(0.3, nrow = n_iter, ncol = 2)
nEvaluations <- 0L
for (i in seq.int(2, n_iter)) {
  out <- slice_elliptical_mv(draws[i - 1,], log_target = lf,
              mu = c(0.5, 0.5), Sig = matrix(c(0.5, 0.25, 0.25, 0.5), nrow = 2))
  draws[i,] <- out$x
  nEvaluations <- nEvaluations + out$nEvaluations
}
nEvaluations / (n_iter - 1)
plot(draws[,1], draws[,2], xlim = c(0, 1))
hist(draws[,1], freq = FALSE); curve(dbeta(x, 3, 4), col = "blue", add = TRUE)
hist(draws[,2], freq = FALSE); curve(dbeta(x, 5, 3), col = "blue", add = TRUE)

}
\references{
Murray, I., Adams, R., and MacKay, D., (2010), "Elliptical Slice Sampling," in \emph{Proceedings of the Thirteenth International Conference on Artificial Intelligence and Statistics}, JMLR Workshop and Conference Proceedings. \url{https://proceedings.mlr.press/v9/murray10a}

Nishihara, R., Murray, I., and Adams, R. P. (2014), "Parallel MCMC with Generalized Elliptical Slice Sampling," \emph{Journal of Machine Learning Research}, 15, 2087-2112. \url{https://jmlr.org/papers/v15/nishihara14a.html}
}
