% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_and_format_files.R
\name{read_fb_mobility_files}
\alias{read_fb_mobility_files}
\title{Read all the .csv files in a folder and format the data.}
\usage{
read_fb_mobility_files(path_to_csvs, colnames, coltypes, keep_format = NULL)
}
\arguments{
\item{path_to_csvs}{Path to the folder where the \code{.csv} files are stored}

\item{colnames}{Columns to include in the results (as character).
For more information go to \code{\link[readr:read_delim]{readr::read_csv()}}}

\item{coltypes}{Column specifications (as strings).
See vignette("readr", package = "readr") for more details.
documentation.}

\item{keep_format}{Vector of column names,
besides \code{date_time}, \code{day} and \code{quadkey}, that you
don't want to convert to a number.}
}
\value{
A data.frame with the information of all the files read.
}
\description{
This function reads all the \code{.csv} files in a particular folder.
These files consistently contain identical columns,
with variations only in location, day, and time.
As a result,
we can uniformly apply specific formatting to columns across these files.
}
\examples{

files <- read_fb_mobility_files(
  path_to_csvs = paste0(system.file("extdata",
    package = "quadkeyr"
  ), "/"),
  colnames = c( # The columns not listed here will be omitted
    "lat",
    "lon",
    "quadkey",
    "date_time",
    "n_crisis",
    "percent_change",
    "day",
    "hour"
  ),
  coltypes = list(
    lat = "d",
    lon = "d",
    quadkey = "c",
    date_time = "T",
    n_crisis = "c",
    percent_change = "c",
    day = "D",
    hour = "i"
  )
)

head(files)
}
\seealso{
\code{\link{format_fb_data}}

\code{\link[readr]{read_csv}}
}
