% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qlm_code.R
\name{qlm_code}
\alias{qlm_code}
\title{Code qualitative data with an LLM}
\usage{
qlm_code(x, codebook, model, ..., batch = FALSE, name = NULL, notes = NULL)
}
\arguments{
\item{x}{Input data: a character vector of texts (for text codebooks) or
file paths to images (for image codebooks). Named vectors will use names
as identifiers in the output; unnamed vectors will use sequential integers.}

\item{codebook}{A codebook object created with \code{\link[=qlm_codebook]{qlm_codebook()}}. Also accepts
deprecated \code{\link[=task]{task()}} objects for backward compatibility.}

\item{model}{Provider (and optionally model) name in the form
\code{"provider/model"} or \code{"provider"} (which will use the default model for
that provider). Passed to the \code{name} argument of \code{\link[ellmer:chat-any]{ellmer::chat()}}.
Examples: \code{"openai/gpt-4o-mini"}, \code{"anthropic/claude-3-5-sonnet-20241022"},
\code{"ollama/llama3.2"}, \code{"openai"} (uses default OpenAI model).}

\item{...}{Additional arguments passed to \code{\link[ellmer:chat-any]{ellmer::chat()}},
\code{\link[ellmer:parallel_chat]{ellmer::parallel_chat_structured()}}, or \code{\link[ellmer:batch_chat]{ellmer::batch_chat_structured()}},
based on argument name. Arguments recognized by
\code{\link[ellmer:parallel_chat]{ellmer::parallel_chat_structured()}} take priority when there are overlaps.
Batch-specific arguments (\code{path}, \code{wait}, \code{ignore_hash}) are only used when
\code{batch = TRUE}. Arguments not recognized by any function will generate a warning.}

\item{batch}{Logical. If \code{TRUE}, uses \code{\link[ellmer:batch_chat]{ellmer::batch_chat_structured()}}
instead of \code{\link[ellmer:parallel_chat]{ellmer::parallel_chat_structured()}}. Batch processing is more
cost-effective for large jobs but may have longer turnaround times.
Default is \code{FALSE}. See \code{\link[ellmer:batch_chat]{ellmer::batch_chat_structured()}} for details.}

\item{name}{Character string identifying this coding run. Default is \code{NULL}.}

\item{notes}{Optional character string with descriptive notes about this
coding run. Useful for documenting the purpose or rationale when viewing
results in \code{\link[=qlm_trail]{qlm_trail()}}. Default is \code{NULL}.}
}
\value{
A \code{qlm_coded} object (a tibble with additional attributes):
\describe{
\item{Data columns}{The coded results with a \code{.id} column for identifiers.}
\item{Attributes}{\code{data}, \code{input_type}, and \code{run} (list containing name, batch, call, codebook, chat_args, execution_args, metadata, parent).}
}
The object prints as a tibble and can be used directly in data manipulation workflows.
The \code{batch} flag in the \code{run} attribute indicates whether batch processing was used.
The \code{execution_args} contains all non-chat execution arguments (for either parallel or batch processing).
}
\description{
Applies a codebook to input data using a large language model, returning
a rich object that includes the codebook, execution settings, results, and
metadata for reproducibility.
}
\details{
Arguments in \code{...} are dynamically routed to either \code{\link[ellmer:chat-any]{ellmer::chat()}},
\code{\link[ellmer:parallel_chat]{ellmer::parallel_chat_structured()}}, or \code{\link[ellmer:batch_chat]{ellmer::batch_chat_structured()}}
based on their names.

Progress indicators and error handling are provided by the underlying
\code{\link[ellmer:parallel_chat]{ellmer::parallel_chat_structured()}} or \code{\link[ellmer:batch_chat]{ellmer::batch_chat_structured()}}
function. Set \code{verbose = TRUE} to see progress messages during coding.
Retry logic for API failures should be configured through ellmer's options.

When \code{batch = TRUE}, the function uses \code{\link[ellmer:batch_chat]{ellmer::batch_chat_structured()}}
which submits jobs to the provider's batch API. This is typically more
cost-effective but has longer turnaround times. The \code{path} argument specifies
where batch results are cached, \code{wait} controls whether to wait for completion,
and \code{ignore_hash} can force reprocessing of cached results.
}
\examples{
\donttest{
# Basic sentiment analysis
texts <- c("I love this product!", "Terrible experience.", "It's okay.")
coded <- qlm_code(texts, data_codebook_sentiment, model = "openai/gpt-4o-mini")
coded

# With named inputs (names become IDs in output)
texts_named <- c(review1 = "Great service!", review2 = "Very disappointing.")
coded2 <- qlm_code(texts_named, data_codebook_sentiment, model = "openai/gpt-4o-mini")
coded2
}

}
\seealso{
\code{\link[=qlm_codebook]{qlm_codebook()}} for creating codebooks, \code{\link[=qlm_replicate]{qlm_replicate()}} for replicating
coding runs, \code{\link[=qlm_compare]{qlm_compare()}} and \code{\link[=qlm_validate]{qlm_validate()}} for assessing reliability.
}
