% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qlm_codebook.R
\name{qlm_codebook}
\alias{qlm_codebook}
\title{Define a qualitative codebook}
\usage{
qlm_codebook(
  name,
  instructions,
  schema,
  role = NULL,
  input_type = c("text", "image"),
  levels = NULL
)
}
\arguments{
\item{name}{Name of the codebook (character).}

\item{instructions}{Instructions to guide the model in performing the coding task.}

\item{schema}{Structured output definition, e.g., created by
\code{\link[ellmer:type_boolean]{ellmer::type_object()}}, \code{\link[ellmer:type_boolean]{ellmer::type_array()}}, or \code{\link[ellmer:type_boolean]{ellmer::type_enum()}}.}

\item{role}{Optional role description for the model (e.g., "You are an expert
annotator"). If provided, this will be prepended to the instructions when
creating the system prompt.}

\item{input_type}{Type of input data: \code{"text"} (default) or \code{"image"}.}

\item{levels}{Optional named list specifying measurement levels for each
variable in the schema. Names should match schema property names. Values
should be one of \code{"nominal"}, \code{"ordinal"}, \code{"interval"}, or \code{"ratio"}.
If \code{NULL} (default), levels are auto-detected from schema types using the
following mapping: \code{type_boolean} and \code{type_enum} = nominal, \code{type_string}
= nominal, \code{type_integer} = ordinal, \code{type_number} = interval.}
}
\value{
A codebook object (a list with class \code{c("qlm_codebook", "task")})
containing the codebook definition. Use with \code{\link[=qlm_code]{qlm_code()}} to apply the
codebook to data.
}
\description{
Creates a codebook definition for use with \code{\link[=qlm_code]{qlm_code()}}. A codebook specifies
what information to extract from input data, including the instructions
that guide the LLM and the structured output schema.
}
\details{
This function replaces \code{\link[=task]{task()}}, which is now deprecated. The returned object
has dual class inheritance (\code{c("qlm_codebook", "task")}) to maintain
backward compatibility.
}
\examples{
# Define a custom codebook
my_codebook <- qlm_codebook(
  name = "Sentiment",
  instructions = "Rate the sentiment from -1 (negative) to 1 (positive).",
  schema = type_object(
    score = type_number("Sentiment score from -1 to 1"),
    explanation = type_string("Brief explanation")
  )
)

# With a role
my_codebook_role <- qlm_codebook(
  name = "Sentiment",
  instructions = "Rate the sentiment from -1 (negative) to 1 (positive).",
  schema = type_object(
    score = type_number("Sentiment score from -1 to 1"),
    explanation = type_string("Brief explanation")
  ),
  role = "You are an expert sentiment analyst."
)

# With explicit measurement levels
my_codebook_levels <- qlm_codebook(
  name = "Sentiment",
  instructions = "Rate the sentiment from -1 (negative) to 1 (positive).",
  schema = type_object(
    score = type_number("Sentiment score from -1 to 1"),
    explanation = type_string("Brief explanation")
  ),
  levels = list(score = "interval", explanation = "nominal")
)

\donttest{
# Use with qlm_code() (requires API key)
texts <- c("I love this!", "This is terrible.")
coded <- qlm_code(texts, my_codebook, model = "openai/gpt-4o-mini")
coded
}

}
\seealso{
\code{\link[=qlm_code]{qlm_code()}} for applying codebooks to data,
\link{data_codebook_sentiment} for a predefined codebook example,
\code{\link[=task]{task()}} for the deprecated function.
}
