% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct.R
\name{distinct.corpus}
\alias{distinct.corpus}
\title{Subset documents distinct/unique by document variables}
\usage{
\method{distinct}{corpus}(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{a corpus object with document variables}

\item{...}{comma-separated list of unquoted document variables, or
expressions involving document variables}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}
}
\value{
A corpus containing only documents with unique combinations of the
specified document variables.
}
\description{
Select only documents that are unique/distinct with respect to values of
their document variables.
}
\examples{
distinct(data_corpus_inaugural[1:5], President) \%>\%
  summary()
distinct(data_corpus_inaugural[1:5], President, .keep_all = TRUE) \%>\%
  summary()
}
