% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/left_join.R
\name{left_join.corpus}
\alias{left_join.corpus}
\title{Join corpus with a data frame}
\usage{
\method{left_join}{corpus}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL
)
}
\arguments{
\item{x}{a \pkg{quanteda} corpus object}

\item{y}{a data frame or tibble to join}

\item{by}{a join specification. See \code{\link[dplyr:mutate-joins]{dplyr::left_join()}} for details.
Defaults to natural join using all variables with common names. Can use
"docname" to join on document names (see Details).}

\item{copy}{if \code{y} is not a data frame or tibble, should it be copied?}

\item{suffix}{if there are non-joined duplicate variables in \code{x} and \code{y},
these suffixes will be added to disambiguate}

\item{...}{other arguments passed to \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}}

\item{keep}{should the join keys from both \code{x} and \code{y} be preserved?}
}
\value{
a corpus with document variables from both \code{x} and \code{y}
}
\description{
\code{left_join()} adds columns from \code{y} to the corpus \code{x}, matching documents
based on document variables. This is a mutating join that keeps all documents
from \code{x} and adds matching values from \code{y}. If a document in \code{x} has no match
in \code{y}, the new columns will contain \code{NA}.
}
\section{Special handling of "docname"}{

This function provides special handling for joining on document names:
\itemize{
\item If \code{by = "docname"} (or "docname" appears in the \code{by} vector), the function
will use \code{docnames(x)} as the joining column from the corpus, even if
"docname" is not a document variable.
\item If using \code{join_by(docname == other_col)}, the function will match
\code{docnames(x)} to \code{other_col} in \code{y}.
\item If "docname" exists as an actual document variable in \code{x}, that variable
will be used instead of \code{docnames(x)}.
}
}

\examples{
# Create example corpus and data
corp <- data_corpus_inaugural[1:5]

# Create data to join with document names
doc_data <- data.frame(
  docname = c("1789-Washington", "1793-Washington", "1797-Adams"),
  century = c(18, 18, 18),
  speech_number = c(1, 2, 1)
)

# Join using docname - matches docnames(corp) to doc_data$docname
left_join(corp, doc_data, by = "docname") \%>\%
  summary()

# Join using different column names with named vector
doc_data2 <- data.frame(
  doc_id = c("1789-Washington", "1793-Washington"),
  rating = c(5, 4)
)
left_join(corp, doc_data2, by = c("docname" = "doc_id")) \%>\%
  summary()

# Regular join on existing docvars
year_info <- data.frame(
  Year = c(1789, 1793, 1797, 1801, 1805),
  decade = c("1780s", "1790s", "1790s", "1800s", "1800s")
)
left_join(corp, year_info, by = "Year") \%>\%
  summary()

}
