% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantPlot.R
\name{QuantPlot}
\alias{QuantPlot}
\title{Plot Univariate Quantile Data}
\usage{
QuantPlot(QKResults, X1 = NULL, Y1 = NULL, main = NULL,
  xlab = NULL, ylab = NULL, colors = NULL)
}
\arguments{
\item{QKResults}{Output from the quantKrig function.}

\item{X1}{X values if ploting the original data in the background}

\item{Y1}{Y values if ploting the original data in the background}

\item{main}{Plot Title defaults to Fitted Quantiles}

\item{xlab}{Label for x-axis defaults to X}

\item{ylab}{Label for y-axis defaults to Y}

\item{colors}{Customize colors associated with the quantiles}
}
\value{
A ggplot object
}
\description{
Plots the Quantile output from quantKrig if there is only one input.
}
\examples{
X <- seq(0,1,length.out = 20)
Y <- cos(5*X) + cos(X)
Xstar <- rep(X,each = 100)
Ystar <- rep(Y,each = 100)
Ystar <- rnorm(length(Ystar),Ystar,1)
Ystar <- (Ystar - mean(Ystar)) / sd(Ystar)
Xstar <- (Xstar - min(Xstar)/ max(Xstar) - min(Xstar))
lb <- c(0.0001,0.0001)
ub <- c(10,10)
Qout <- quantKrig(Xstar,Ystar, seq(0.05,0.95, length.out = 7), lower = lb, upper = ub)
QuantPlot(Qout, Xstar, Ystar)

}
