% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mestimate.R
\name{mestimate}
\alias{mestimate}
\title{The Mean-Optimal Treatment Regime Wrapper Function}
\usage{
mestimate(x, y, a, prob, p_level, nvars, hard_limit = FALSE, max = TRUE,
  cl.setup = 1, s.tol = 1e-04, it.num = 8, pop.size = 3000)
}
\arguments{
\item{x}{a matrix of observed covariates from the sample. 
Notice that we assumed the class of treatment regimes is linear.}

\item{y}{a vector, the observed responses from a sample}

\item{a}{a vector of 0s and 1s, the observed treatments from a sample}

\item{prob}{a vector, the propensity scores of getting treatment 1 in the samples}

\item{p_level}{choose between 0,1,2,3 to indicate different levels of output
from the genetic function. Specifically, 0 (minimal printing),
  1 (normal), 2 (detailed), and 3 (debug.)}

\item{nvars}{an integer. The number of parameters indexing a treatment regime.}

\item{hard_limit}{logical. This logical variable determines if the
max.generations variable is a binding constraint for genoud.}

\item{max}{logical. If \code{max=TRUE}, it indicates we wish to maximize the marginal
mean; If \code{max=FALSE}, we wish to minimize the marginal mean. The default is \code{TRUE}.}

\item{cl.setup}{the number of nodes. >1 indicates choosing parallel computing option in 
\code{rgenoud::genoud}. Default is 1.}

\item{s.tol}{This is the tolerance level used by \code{genoud}. 
Default is \eqn{10^{-5}} times the difference between
the largest and the smallest value in the observed responses.
This is particularly important when it comes to evaluating \code{it.num}.}

\item{it.num}{integer > 1. This argument will be used in \code{rgeound::geound} function.
    If there is no improvement in the objective function in this number of generations,
\code{rgenoud::genoud} will think that it has found the optimum.}

\item{pop.size}{an integer with the default set to be 3000. This is the population number for the first generation
in the genetic algorithm (\code{rgenoud::genoud}).}
}
\description{
The wrapper function for mean-optimal treatment regime that calls a genetic algorithm.
This function supports the \code{\link{IPWE_Mopt}} function.
}
\references{
\insertRef{zhang2012robust}{quantoptr}
}
\seealso{
The function \code{\link{IPWE_Mopt}} is based on this function.
}
