% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{valids_test}
\alias{valids_test}
\title{Test for Invalid Elements in Data}
\usage{
valids_test(data, vrb.nm, valid, na.rm = TRUE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables}

\item{valid}{atomic vector or list vector of valid values.}

\item{na.rm}{logical vector of length 1 specifying whether NA should be
ignored from the validity test. If TRUE (default), then any NAs are treated
as valid.}
}
\value{
logical vector with length = \code{length(vrb.nm)} and names =
  \code{vrb.nm} specifying whether all elements in each variable of
  \code{data[vrb.nm]} are valid. If FALSE, then (at least one) invalid values
  are present in that variable of \code{data[vrb.nm]}.
}
\description{
\code{Valid.test} tests whether data has any invalid elements. Valid values
are specified by \code{valid}. Each variable is tested independently. If the
variable in \code{data[vrb.nm]} has any values other than \code{valid}, then
FALSE is returned for that variable; If the variable in \code{data[vrb.nm]}
only has values in \code{valid}, then TRUE is returned for that variable.
}
\examples{
valids_test(data = psych::bfi, vrb.nm = names(psych::bfi)[1:25],
   valid = 1:6) # return TRUE
valids_test(data = psych::bfi, vrb.nm = names(psych::bfi)[1:25],
   valid = 0:5) # 6 is not present in `valid`
valids_test(data = psych::bfi, vrb.nm = names(psych::bfi)[1:25],
   valid = 1:6, na.rm = FALSE) # NA is not present in `valid`
valids_test(data = ToothGrowth, vrb.nm = c("supp","dose"),
   valid = list("VC", "OJ", 0.5, 1.0, 2.0)) # list vector as `valid` to allow for
   # elements of different typeof
}
\seealso{
\code{\link{valid_test}}
   \code{\link{revalids}}
   \code{\link{revalid}}
}
