% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat_outliers.R
\name{treat_outliers}
\alias{treat_outliers}
\title{Treat Outliers (Winsorization/Capping)}
\usage{
treat_outliers(data, column, method = "iqr", threshold = 1.5)
}
\arguments{
\item{data}{A data frame.}

\item{column}{The numeric column to treat.}

\item{method}{"iqr" or "zscore".}

\item{threshold}{Numeric (1.5 for IQR, 3 for zscore).}
}
\value{
A data frame with the modified column values.
}
\description{
Instead of removing outliers, this function replaces extreme values with the calculated
upper and lower boundaries (caps). This technique is often called "Winsorization".
}
\examples{
# Example: 100 is an outlier
df <- data.frame(val = c(1, 2, 3, 2, 1, 100))

# The 100 will be replaced by the maximum allowed IQR value
clean_df <- treat_outliers(df, "val", method = "iqr")
print(clean_df$val)
}
