% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-other.R
\name{dev}
\alias{dev}
\title{Specify where to plot}
\usage{
dev(x, ..., verbose = getOption("quickPlot.verbose"))
}
\arguments{
\item{x}{The number of a plot device. If missing, will open a new
non-RStudio plotting device}

\item{...}{Additional arguments passed to \code{\link[=newPlot]{newPlot()}}.}

\item{verbose}{Numeric or logical. If \code{TRUE} or \verb{>0}, then messages will be
shown. If \code{FALSE} or \code{0}, most messages will be suppressed.}
}
\value{
Opens a new plot device on the screen.
Invisibly returns the device number selected.
}
\description{
Switch to an existing plot device, or if not already open,
launch a new graphics device based on operating system used.
On Windows and macOS, if \code{x} is not provided, this will open or switch to the first
non-RStudio device, which is much faster than the \file{png}-based RStudio plot device.
Currently, this will not open anything new.
}
\details{
For example, \code{dev(6)} switches the active plot device to device 6.
If it does not exist, it opens it. If devices 1-5 don't exist they will be opened too.
}
\examples{
\dontrun{
dev(4)
}

}
\author{
Eliot McIntire and Alex Chubaty
}
