% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2mlm3_manual.R
\name{r2mlm3_manual}
\alias{r2mlm3_manual}
\title{Compute R-squared values for three-level multilevel models, manually
inputting parameter estimates.}
\usage{
r2mlm3_manual(
  data,
  l1_covs,
  l2_covs,
  l3_covs,
  random_covs12,
  random_covs13,
  random_covs23,
  gamma_1,
  gamma_2,
  gamma_3,
  Tau12,
  Tau13,
  Tau23,
  sigma2,
  clustermeancentered = TRUE,
  Tau2_noncmc = NULL,
  Tau3_noncmc = NULL,
  l2clusterID_noncmc = NULL,
  l3clusterID_noncmc = NULL,
  bargraph = TRUE
)
}
\arguments{
\item{data}{Dataset with rows denoting observations and columns denoting
variables}

\item{l1_covs}{Vector of numbers (or variable names) corresponding to the
columns in the dataset of the level-1 predictors used in the MLM (if none
used, set to NULL)}

\item{l2_covs}{Vector of numbers (or variable names) corresponding to the
columns in the dataset of the level-2 predictors used in the MLM (if none
used, set to NULL)}

\item{l3_covs}{Vector of numbers (or variable names) corresponding to the
columns in the dataset of the level-3 predictors used in the MLM (if none
used, set to NULL)}

\item{random_covs12}{Vector of numbers (or variable names) corresponding to
the columns in the dataset of the level-1 predictors that have random
slopes across level-2 units in the MLM (if no such random slopes, set to
NULL)}

\item{random_covs13}{Vector of numbers (or variable names) corresponding to
the columns in the dataset of the level-1 predictors that have random
slopes across level-3 units in the MLM (if no such random slopes, set to
NULL)}

\item{random_covs23}{Vector of numbers (or variable names) corresponding to
the columns in the dataset of the level-2 predictors that have random
slopes across level-3 units in the MLM (if no such random slopes, set to
NULL)}

\item{gamma_1}{Vector of fixed slope estimates for all level-1 predictors, to
be entered in the order of the predictors listed by l1_covs (if none, set
to NULL)}

\item{gamma_2}{Vector of fixed slope estimates for all level-2 predictors, to
be entered in the order of the predictors listed by l2_covs (if none, set
to NULL)}

\item{gamma_3}{Vector of fixed slope estimates for all level-3 predictors, to
be entered in the order of the predictors listed by l3_covs (if none, set
to NULL)}

\item{Tau12}{For cluster-mean-centered model results (set to NULL if entering
non-cluster-mean-centered model results), this is the random effect
covariance matrix with the first row/column denoting the intercept variance
and covariances across level-2 units and each subsequent row/column denotes
a given level-1 predictor’s random slope variance and covariances across
level-2 units (to be entered in the order listed by random_covs12; if none,
set to NULL)}

\item{Tau13}{For cluster-mean-centered model results (set to NULL if entering
non-cluster-mean-centered model results), this is the random effect
covariance matrix with the first row/column denoting the intercept variance
and covariances across level-3 units and each subsequent row/column denotes
a given level-1 predictor’s random slope variance and covariances across
level-3 units (to be entered in the order listed by random_covs13; if none,
set to NULL)}

\item{Tau23}{For cluster-mean-centered model results (set to NULL if entering
non-cluster-mean-centered model results), this is the random effect
covariance matrix with each row/column denoting a given level-2 predictor’s
random slope variance and covariances across level-3 units (to be entered
in the order listed by random_covs23; if none, set to NULL)}

\item{sigma2}{Level-1 residual variance}

\item{clustermeancentered}{By default, this argument is set to TRUE,
indicating that cluster-mean-centered model results are being inputted.
When instead entering non-cluster-mean-centered model results, set this
argument to FALSE. Additionally, for non-cluster-mean-centered model
results, random effect variances/covariances are to be entered in arguments
Tau2_noncmc and Tau3_noncmc (defined below), rather than in the Tau12,
Tau13, and Tau23 arguments used for cluster-mean-centered model results.
Additionally, when entering non-cluster-mean-centered model results, user
must specify l2clusterID_noncmc and l3clusterID_noncmc (neither of which
are necessary for cluster-mean-centered model results). Function input is
otherwise the same for cluster-mean-centered and non-cluster-mean-centered
model results.}

\item{Tau2_noncmc}{For non-cluster-mean-centered model results, this is the
level-2 random effect covariance matrix; the first row/column denotes the
intercept variance and covariances across level-2 units and each subsequent
row/column denotes a given predictor’s random slope variance and
covariances across level-2 units (to be entered in the order listed by
randomcovsl2_noncmc; by default, this argument is set to NULL)}

\item{Tau3_noncmc}{For non-cluster-mean-centered model results, this is the
level-3 random effect covariance matrix; the first row/column denotes the
intercept variance and covariances across level-3 units and each subsequent
row/column denotes a given predictor’s random slope variance and
covariances across level-3 units (to be entered in the order listed by
randomcovsl2_noncmc; by default, this argument is set to NULL)}

\item{l2clusterID_noncmc}{For non-cluster-mean-centered model results, this
is the number (or variable name) corresponding to the column in the dataset
containing the level-2 cluster identification (function assumes that each
level-2 cluster ID is unique; by default, this argument is set to NULL)}

\item{l3clusterID_noncmc}{For non-cluster-mean-centered model results, this
is the number (or variable name) corresponding to the column in the dataset
containing the level-3 cluster identification (function assumes that each
level-3 cluster ID is unique; by default, this argument is set to NULL)}

\item{bargraph}{Optional bar graph output, default is TRUE.}
}
\value{
If the input is valid, then the output will be a list and associated
  graphical representation of R-squared decompositions. If the input is not
  valid, it will return an error.
}
\description{
\code{r2mlm3_manual} takes as input raw data and three-level multilevel model
(MLM) parameter estimates and outputs all relevant R-squared measures as well
as an accompanying bar chart.
}
\details{
This function can also accommodate two-level models. To input results
for two-level models, set the following arguments equal to NULL: l3_covs,
random_covs13, random_covs23, gamma_3, Tau13, Tau23.
}
\seealso{
Other r2mlm single model functions: 
\code{\link{r2mlm_ci}()},
\code{\link{r2mlm_long_manual}()},
\code{\link{r2mlm_manual}()},
\code{\link{r2mlm}()}
}
\concept{r2mlm single model functions}
