% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lts_lines2shp}
\alias{lts_lines2shp}
\title{Save LTS lines to shapefile temporary file}
\usage{
lts_lines2shp(new_lts_lines)
}
\arguments{
\item{new_lts_lines}{An sf LINESTRING or MULTILINESTRING}
}
\value{
The path to a \code{.shp} saved as a temporary file.
}
\description{
Support function that checks the input of LTS lines passed to
and saves it to a \code{.shp} temporary file.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# read lines with new speeds
new_lts_lines <- readRDS(
  system.file("extdata/poa/poa_ls_lts.rds", package = "r5r")
  )

shp_path <- r5r:::lts_lines2shp(
  new_lts_lines = new_lts_lines
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other Support functions: 
\code{\link{congestion_poly2geojson}()}
}
\concept{Support functions}
\keyword{internal}
