% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_lmt_twap_gtd_order}
\alias{cb_lmt_twap_gtd_order}
\title{Spot: Place Limit TWAP Order}
\usage{
cb_lmt_twap_gtd_order(
  client_order_id = cb_get_order_id(),
  product_id,
  side,
  base_size,
  order_start,
  order_exp,
  limit_price,
  number_buckets,
  bucket_duration
)
}
\arguments{
\item{client_order_id}{= (string) A unique ID provided for the order (used for identification purposes) Example: 0000-00000-000000}

\item{product_id}{= (string) The trading pair (e.g. 'BTC-USD'). Example: BTC-USD}

\item{side}{= (string) The side of the market that the order is on (e.g. 'BUY', 'SELL'). Possible values: BUY, SELL}

\item{base_size}{= (string) The amount of the first Asset in the Trading Pair. Example: 0.001}

\item{order_start}{= (TimeStamp) Enter the time you wish to cancel if not filled: Ex. Sys.time()+minutes(5)}

\item{order_exp}{= (TimeStamp) Enter the time you wish to cancel if not filled: Ex. Sys.time()+minutes(10)}

\item{limit_price}{= (string) The specified price, or better, that the Order should be executed at. A Buy Order will execute at or lower than the limit price. A Sell Order will execute at or higher than the limit price. Example: 10000.00}

\item{number_buckets}{= (string) The number of smaller buckets/suborders over which the entire order will be broken into. Each suborder will be executed over a duration calculated based on the end_time. Example: 5}

\item{bucket_duration}{= (string) The duration over which each sub order was executed. Example: 300s}
}
\value{
returns order details as a \code{data.frame} for limit TWAP orders
}
\description{
Spot: Place Limit TWAP Order
}
\examples{
\dontrun{
  cb_lmt_twap_gtd_order(product_id = "BTC-USD",
                        side = "BUY",
                        base_size = '0.00004',
                        order_start = Sys.time() + minutes(1),
                        order_exp = Sys.time()+minutes(6),
                        limit_price = '100000',
                        number_buckets = 2,
                        bucket_duration = "300")
}
}
