% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_order_builder}
\alias{cb_order_builder}
\title{Order Builder}
\usage{
cb_order_builder(
  order_type,
  client_order_id,
  product_id,
  side,
  leverage = 1,
  margin_type = "CROSS",
  preview_id = NULL,
  base_size = NULL,
  quote_size = NULL,
  start_time = NULL,
  end_time = NULL,
  limit_price = NULL,
  number_buckets = NULL,
  bucket_duration = NULL,
  bucket_size = NULL,
  post_only = FALSE,
  stop_price = NULL,
  stop_direction = NULL,
  stop_trigger_price = NULL
)
}
\arguments{
\item{order_type}{= (string) type of order : "market_market_ioc"}

\item{client_order_id}{= (string) A unique ID provided for the order (used for identification purposes) Example: 0000-00000-000000}

\item{product_id}{= (string) The trading pair (e.g. 'BTC-USD'). Example: BTC-USD}

\item{side}{= (string) The side of the market that the order is on (e.g. 'BUY', 'SELL'). Possible values: BUY, SELL}

\item{leverage}{= (string) The amount of leverage for the order (default is 1.0). Example: 2.0}

\item{margin_type}{= (string) Margin Type for this order (default is CROSS). Possible values: CROSS, ISOLATED}

\item{preview_id}{= (string) Preview ID for this order, to associate this order with a preview request. Example: b40bbff9-17ce-4726-8b64-9de7ae57ad26}

\item{base_size}{= (string) The amount of the first Asset in the Trading Pair. Example: 0.001}

\item{quote_size}{= (string) The amount of the second Asset in the Trading Pair. Example: 10.00}

\item{start_time}{= (RFC3339 Timestamp) Time at which the order should begin executing. Example: 2021-05-31T07:59:59Z}

\item{end_time}{= (RFC3339 Timestamp) The time at which the order will be canceled if it is not Filled. Example: 2021-05-31T09:59:59Z}

\item{limit_price}{= (string) The specified price, or better, that the Order should be executed at. A Buy Order will execute at or lower than the limit price. A Sell Order will execute at or higher than the limit price. Example: 10000.00}

\item{number_buckets}{= (string) The number of smaller buckets/suborders over which the entire order will be broken into. Each suborder will be executed over a duration calculated based on the end_time. Example: 5}

\item{bucket_duration}{= (string) The duration over which each sub order was executed. Example: 300s}

\item{bucket_size}{= (string)  The size of each suborder. bucket_size multiplied by number_buckets should match the size of the entire twap order)}

\item{post_only}{= (boolean) Enable or disable Post-only Mode. When enabled, only Maker Orders will be posted to the Order Book. Orders that will be posted as a Taker Order will be rejected.}

\item{stop_price}{= (string) The specified price that will trigger the placement of the Order. Example: 20000.00}

\item{stop_direction}{= (string) The direction of the stop limit Order. Possible values: STOP_DIRECTION_STOP_UP, STOP_DIRECTION_STOP_DOWN}

\item{stop_trigger_price}{= (string) The price level (in quote currency) where the position will be exited. When triggered, a stop limit order is automatically placed with a limit price 5\% higher for BUYS and 5\% lower for SELLS. Example: 20000.00}
}
\value{
returns a \code{list} for the order configuration depending on the order type
}
\description{
Order Builder
}
\examples{
\dontrun{
  cb_order_builder(order_type="market_market_ioc", client_order_id='1234',
                   product_id="BTC-USD", side="BUY", leverage = 1.0,
                   margin_type='CROSS',preview_id=NULL,
                   base_size="0.00001", quote_size=NULL,
                   start_time=NULL, end_time=NULL, limit_price=NULL,
                   number_buckets=NULL, bucket_duration=NULL,
                   bucket_size = NULL, post_only=FALSE,
                   stop_price=NULL, stop_direction=NULL,
                   stop_trigger_price=NULL)
}
}
