% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{sphere_norm}
\alias{sphere_norm}
\title{Apply Spherical Normalization to ENA Data}
\usage{
sphere_norm(x, add.meta = TRUE)
}
\arguments{
\item{x}{An `ena.set` object or a numeric matrix of connection counts.}

\item{add.meta}{A logical value. If `TRUE` (the default), metadata from the `ena.set` is preserved and included in the output. This parameter is ignored if `x` is a matrix.}
}
\value{
If `x` is an `ena.set`, it returns the modified `ena.set` with a new `line.weights` matrix and an updated `centervec` in the `rotation` object. If `x` is a matrix, it returns a matrix of normalized line weights.
}
\description{
This function applies spherical normalization to the connection counts in an `ena.set` object or to a raw matrix of connection counts. Normalization is a key step before centering and rotation in ENA.
}
\examples{
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon) |>
  sphere_norm()
}
