% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.FSA.R
\name{plot.FSA}
\alias{plot.FSA}
\title{Diagnostic Plots for FSA solutions}
\usage{
\method{plot}{FSA}(x, ask = F, easy = T, ...)
}
\arguments{
\item{x}{FSA object to see diagnostic plots on.}

\item{ask}{logical; if TRUE, the user is asked before each plot. See help(plot.lm).}

\item{easy}{logical; should diagnostic plots be presented in easy to read format?}

\item{...}{arguments to be passed to other functions.}
}
\value{
diagnostic plots to plot window.
}
\description{
Diagnostic Plots for FSA solutions
}
\examples{
#use mtcars package see help(mtcars)
data(mtcars)
colnames(mtcars)
fit<-lmFSA(formula="mpg~hp*wt",data=mtcars,fixvar="hp",
           quad=FALSE,m=2,numrs=10,save_solutions=FALSE,cores=1)
plot(x=fit)
}
