% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{cdd}
\alias{cdd}
\title{Calculate Consecutive Dry Days (CDD)}
\usage{
cdd(ci, spells_can_span_years = TRUE, monthly = TRUE)
}
\arguments{
\item{ci}{List. Climate input object created by \code{\link{climate_input}}.}

\item{spells_can_span_years}{Logical. Whether spells can span across years (default is TRUE).}

\item{monthly}{Logical. Whether to interpolate annual data to monthly data (default is TRUE).}
}
\value{
Data frame with dates and calculated CDD values.
}
\description{
Calculates the maximum length of consecutive dry days.
}
\examples{
\donttest{
# 1. Generate a daily date sequence from 1960-01-01 to 2020-12-31
dates <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-31"),
  by   = "day"
)

# 2. Create random weather data for each date
n <- length(dates)
tmax <- runif(n, min = 5, max = 40)
tmin <- runif(n, min = -10,  max = 5)
# Example: use a Poisson distribution to simulate precipitation
prec <- rpois(n, lambda = 2)
# Random wind speeds, e.g., 0 to 10 m/s
wind <- runif(n, min = 0, max = 10)

# 3. Construct the climate_input object
ci <- climate_input(
  tmax  = tmax,
  tmin  = tmin,
  prec  = prec,
  wind  = wind,
  dates = dates
)
# Then:
# 4. Calculate annual CDD index
cdd_values <- cdd(ci, monthly = FALSE)
}
}
