% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcOverlap.R
\name{calcOverlap}
\alias{calcOverlap}
\title{Calculate Percent Overlap of Isotopic Niche Space}
\usage{
calcOverlap(estObj)
}
\arguments{
\item{estObj}{List object of class estObj containing returned sf data frames from estimating functions estKIN, etc.}
}
\value{
A data.frame containing the percent of the polygon overlap for each group and level. Rows are the 1st input polygon, columns are the 2nd input, the returned area of overlap is divided by the area of the 1st polygon (row).
}
\description{
Calculates the percent of polygon overlap between each group and level.
}
\examples{
library(rKIN)
data("rodents")
#estimate niche overlap between 2 species using kernel UD
test.kin<- estKIN(data=rodents, x="Ave_C", y="Ave_N", group="Species",
                   levels=c(50, 75, 95), scaler=2)
#determine polygon overlap for all polygons
dat.olp<- calcOverlap(test.kin)
}
\author{
Shannon E. Albeke, Wyoming Geographic Information Science Center, University of Wyoming
}
