% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMEA_artefact.R
\name{MEAreplace}
\alias{MEAreplace}
\title{Substitute values from MEA data}
\usage{
MEAreplace(mea, epochs, replacement, filterLabel = "replaced")
}
\arguments{
\item{mea}{an object of class \code{MEA} or a list of \code{MEA} objects (see function \code{\link{readMEA}})}

\item{epochs}{a data.frame containing a list of epochs that must be changed (see Details)}

\item{replacement}{the value used to mark artefacts. Use 'NA' to remove artefacts and '0' to apply thresholds.
Other values are allowed but should not be used without a good reason.}

\item{filterLabel}{can be used to update the \code{filter} attribute, to keep track of the data transformations.}
}
\value{
returns the same \code{MEA} or \code{MEAlist} object, with all artefactual data substituted.
}
\description{
This function allows to substitute MEA data from a list of time epochs. This is useful to mark and remove artefacts,
or to substitute extreme values.
}
\details{
the \code{artefacts} data.frame must contain a "start" and "end" columns, with the boundaries of the epochs that must be
marked as artefacts. The start and end values can be either integers (denoting seconds), or string values in the format hh:mm:ss, or mm:ss.
Furthermore the data.frame must contain a \code{uid} column containing strings in the format "group_id_session", OR three columns \code{group, id, session}
presenting the information separately. Data identifiers must match those of the \code{mea} object.

The data.frame can be either hand crafted, for instance by importing a csv file (see \code{\link[utils]{read.table}}), or
generated through the packages own artefact detection tools such as \code{\link{CCFartefacts}}
}
\examples{
#' ## read the first 4 minutes of the normal sample
## (intake interviews of patients that carried on therapy)
path_normal <- system.file("extdata/normal", package = "rMEA")
mea_normal <- readMEA(path_normal, sampRate = 25, s1Col = 1, s2Col = 2,
                      s1Name = "Patient", s2Name = "Therapist",
                      idOrder = c("id","session"), idSep="_", skip=1, nrow = 6000)
mea_normal <- MEAccf(mea_normal, lagSec = 5, winSec = 30, incSec = 10, ABS = FALSE)

## find potential artefacts
artefacts = CCFartefacts(mea_normal, threshold = 0.2, delta=1)

##replace values
mea_replaced <- MEAreplace(mea_normal, epochs = artefacts,
                           replace = NA, filterLabel = "artefacts deletion")

#visualize results on first case
plot(mea_normal$all_200_1)
plot(mea_replaced$all_200_1)


}
