% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_getOptChains}
\alias{rp_getOptChains}
\title{Get Option Chains}
\usage{
rp_getOptChains(accountId, ticker, type, exp)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{ticker}{= Ticker symbol: Ex. "SPY"}

\item{type}{= Ticker Type: Ex. 'EQUITY','OPTION','MULTI_LEG_INSTRUMENT', 'CRYPTO', 'ALT','TREASURY', 'BOND', 'INDEX'}

\item{exp}{= Option Expiration Date: Ex. "2025-08-08"}
}
\value{
Retrieve option chains by symbol and return as a \code{data.frame}.
}
\description{
Get Option Chains
}
\examples{
\dontrun{
 # Fetches Option Chains for Ticker Symbol
 my_acc <- rp_getAccts()
 rp_getOptChains(accountId = my_acc$accountId, ticker = 'SPY', type = "EQUITY", exp="2025-08-15") 
}
}
