% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_webp_anim}
\alias{agg_webp_anim}
\title{Draw an animation to a WebP file}
\usage{
agg_webp_anim(
  filename = "Ranim.webp",
  width = 480,
  height = 480,
  units = "px",
  pointsize = 12,
  background = "white",
  res = 72,
  scaling = 1,
  snap_rect = TRUE,
  lossy = FALSE,
  quality = 80,
  delay = 100L,
  loop = 0L,
  bg
)
}
\arguments{
\item{filename}{The name of the file. This function does not perform page
number substitution as the other devices since it cannot produce multiple
pages.}

\item{width, height}{The dimensions of the device}

\item{units}{The unit \code{width} and \code{height} is measured in, in either pixels
(\code{'px'}), inches (\code{'in'}), millimeters (\code{'mm'}), or centimeter (\code{'cm'}).}

\item{pointsize}{The default pointsize of the device in pt. This will in
general not have any effect on grid graphics (including ggplot2) as text
size is always set explicitly there.}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{scaling}{A scaling factor to apply to the rendered line width and text
size. Useful for getting the right dimensions at the resolution that you
need. If e.g. you need to render a plot at 4000x3000 pixels for it to fit
into a layout, but you find that the result appears to small, you can
increase the \code{scaling} argument to make everything appear bigger at the
same resolution.}

\item{snap_rect}{Should axis-aligned rectangles drawn with only fill snap to
the pixel grid. This will prevent anti-aliasing artifacts when two
rectangles are touching at their border.}

\item{lossy}{Use lossy compression. Default is \code{FALSE}.}

\item{quality}{An integer between \code{0} and \code{100} defining either the quality
(if using lossy compression) or the compression effort (if using lossless).}

\item{delay}{Per-frame delay in milliseconds (single integer)}

\item{loop}{Number of loops (0 = infinite)}

\item{bg}{Same as \code{background} for compatibility with old graphic device APIs}
}
\description{
The WebP format is a raster image format that provides improved lossless (and
lossy) compression for images on the web. Transparency is supported.
}
\examples{
\dontrun{
file <- tempfile(fileext = '.webp')
agg_webp_anim(file, delay = 100, loop = 0)
for(i in 1:10) {
  plot(sin(1:100 + i/10), type = 'l', ylim = c(-1, 1))
  dev.flush()
}
dev.off()
}
}
\seealso{
\code{\link[=agg_webp]{agg_webp()}} for static WebP images
}
