% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{logspace}
\alias{logspace}
\title{Logarithmically-spaced Elements}
\usage{
logspace(a, b, n = 50, base = 10)
}
\arguments{
\item{a}{\code{base^a} is the starting value of the sequence.}

\item{b}{\code{base^b} is the final value of the sequence.}

\item{n}{The number of samples to generate. Default is 50.}

\item{base}{The base of the log space.}
}
\value{
A vector of logarithmically-spaced elements.
}
\description{
Construct a vector of \code{n} logarithmically-spaced elements from
10^\code{a} to 10^\code{b}.
}
\note{
If \code{b = pi} and \code{base = 10}, the points are between
\code{10^a} and \code{pi}, not \code{10^a} and \code{10^pi}, for
compatibility with the corresponding MATLAB/Octave, and NumPy functions.
}
\seealso{
\code{\link[=linspace]{linspace()}}, \code{\link[=seq]{seq()}}.
}
