% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt_linestring.R
\name{wkt_linestring}
\alias{wkt_linestring}
\title{Random WKT linestring}
\usage{
wkt_linestring(count = 1, num_vertices = 10, max_length = 1e-04,
  max_rotation = pi/8, bbox = NULL, fmt = 7)
}
\arguments{
\item{count}{(integer/numeric) number of Polygons. Default: 1}

\item{num_vertices}{(integer/numeric) how many coordinates each polygon will
contain. Default: 10}

\item{max_length}{(integer/numeric) maximum number of decimal degrees (1
degree = approximately 69 miles or 111 km) that a vertex can be from its
predecessor. Default: 0.0001}

\item{max_rotation}{(integer/numeric) the maximum number of radians that a
line segment can turn from the previous segment. Default: pi / 8}

\item{bbox}{(integer/numeric) lat/long bounding box for the starting point of
the line, numeric vector of the form \code{west (long), south (lat), east
  (long), north (lat)}. optional}

\item{fmt}{(integer/numeric) number of digits. Default: 7}
}
\value{
WKT; a character vector with one or more LINESTRING strings
}
\description{
Random WKT linestring
}
\examples{
wkt_linestring()
wkt_linestring(10)
wkt_linestring(num_vertices = 4)
wkt_linestring(bbox = c(50, 50, 60, 60))
}
