% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmf.R
\name{naive_nmf}
\alias{naive_nmf}
\title{A naive implementation of non-negative matrix factorization}
\usage{
naive_nmf(x, k, tol = c(1e-04, 1e-08), max_iters = 10000, verbose = TRUE)
}
\arguments{
\item{x}{a matrix, or can be converted into a matrix; all negative or missing
values will be treated as zero}

\item{k}{decomposition rank}

\item{tol}{stop criteria, a numeric of two; the first number is the
tolerance for root-mean-squared residuals, relative to the largest number in
\code{x}; the second number is the tolerance for weight differences; any
stopping criteria met will result in the stop of iteration}

\item{max_iters}{maximum iterations}

\item{verbose}{whether to report the progress; logical or a positive integer
(of step intervals)}
}
\value{
A list of weights (non-negative template matrix \code{W} and
non-negative \code{H}) and errors (root mean squared error of fitted,
matrix \code{W}, and \code{W} versus their previous iteration, respectively).
}
\description{
A pure-R vanilla implementation assuming inputs are non-negative matrices
without \code{NA}.
}
\examples{



x <- stats::toeplitz(.9 ^ (0:31))

nmf <- naive_nmf(x, k = 7, verbose = FALSE)

fitted <- nmf$W \%*\% nmf$H

oldpar <- par(mfrow = c(1, 2))
on.exit({ par(oldpar )})

image(x, zlim = c(0, 1), main = "Input")
image(fitted, zlim = c(0, 1),
      main = sprintf("Fitted with rank=\%d", nmf$k))




}
