% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/farrival.R
\name{wave_arrival}
\alias{wave_arrival}
\title{Filter the ray paths that arrives in an area of interest}
\usage{
wave_arrival(x, aoi = NULL, xmin, xmax, ymin, ymax, ofile)
}
\arguments{
\item{x}{sf data.frame object with the LINESTRINGS to be filtered.}

\item{aoi}{String giving the path and the filename of the area of interest.
By default is NULL. If no \strong{aoi} is not provided, the xmin, xmax, ymin,
and ymax must be provided.}

\item{xmin}{Numeric. Indicates the western longitude to be used in the
range -180 to 180.}

\item{xmax}{Numeric. Indicates the eastern longitude to be used in the
range -180 to 180.}

\item{ymin}{Numeric. Indicates the southern longitude to be used in the
range -90 to 90.}

\item{ymax}{Numeric. Indicates the northern longitude to be used in the
range -90 to 90.}

\item{ofile}{Character;  Output file name with .csv extension,
for instance, "/user/aoi_ray.csv"}
}
\value{
sf data.frame
}
\description{
\code{wave_arrival} ingests the ray paths to filter by determined area of
interest. Default CRS 4326.
}
\examples{
{
}
}
