% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.R
\name{select_bandwidth}
\alias{select_bandwidth}
\title{Select Optimal Bandwidth}
\usage{
select_bandwidth(
  X,
  Y = NULL,
  method = "cv",
  kernel.fun = "normal",
  if_approx_kernel = TRUE,
  kernel.resol = 1000
)
}
\arguments{
\item{X}{A numerical vector of sample data.}

\item{Y}{Optional. A numerical vector of sample data for conditional expectation estimation.}

\item{method}{A string specifying the bandwidth selection method. Options are "cv" for
cross-validation and "silverman" for Silverman's rule of thumb. Defaults to "cv".}

\item{kernel.fun}{A string specifying the kernel type. Options include "normal", "epanechnikov",
"Schennach2004", and "sinc".}

\item{if_approx_kernel}{Logical. If TRUE, uses approximations for the kernel function.}

\item{kernel.resol}{The resolution for kernel function approximation.}
}
\value{
A scalar representing the optimal bandwidth.
}
\description{
Selects an optimal bandwidth using the specified method.
}
\examples{
# Generate sample data
X <- rnorm(100)
# Get optimal bandwidth using cross-validation with normal kernel
h_opt <- select_bandwidth(X, method = "cv", kernel.fun = "normal")
# Get optimal bandwidth using Silverman's rule with Schennach kernel
h_opt <- select_bandwidth(X, method = "silverman", kernel.fun = "Schennach2004")
}
