% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_DEA.R
\name{conditional_DEA}
\alias{conditional_DEA}
\title{Conditional DEA function}
\usage{
conditional_DEA(
  input,
  output,
  exogenous = FALSE,
  alpha = FALSE,
  m,
  B,
  RTS = "crs",
  ORIENTATION = "in",
  similarity = FALSE,
  inclusion = FALSE,
  print = FALSE
)
}
\arguments{
\item{input}{matrix (or vector) of inputs along which the units are evaluated.}

\item{output}{matrix (or vector) of outputs along which the units are evaluated.}

\item{exogenous}{matrix (or vector) of exogenous variables involved in the conditional analysis. The similarity among the units is determined according to the exogeneous variable(s) using the function npudensbw and npudens (from the package np) with epanechnikov kernel.}

\item{alpha}{This allow to choose the size of the Confidence Intervals computed. By defaulta alpha = FALSE. In this case no confidence interval are computed}

\item{m}{number of unit to be included in the reference set}

\item{B}{number of bootstrap replicates}

\item{RTS}{For more details see the dea function in the package Benchmarking. Text string or a number defining the underlying DEA technology / returns to scale assumption.
0    fdh    Free disposability hull, no convexity assumption
1    vrs    Variable returns to scale, convexity and free disposability
2    drs    Decreasing returns to scale, convexity, down-scaling and free disposability
3    crs    Constant returns to scale, convexity and free disposability
4    irs    Increasing returns to scale, (up-scaling, but not down-scaling), convexity and free disposability
5    irs2    Increasing returns to scale (up-scaling, but not down-scaling), additivity, and free disposability
6    add    Additivity (scaling up and down, but only with integers), and free disposability; also known af replicability and free disposability, the free disposability and replicability hull (frh) -- no convexity assumption
7    fdh+    A combination of free disposability and restricted or local constant return to scale
10    vrs+    As vrs, but with restrictions on the individual lambdas via param}

\item{ORIENTATION}{For more details see the dea function in the package Benchmarking. Input efficiency "in" (1), output efficiency "out" (2), and graph efficiency "graph" (3). For use with DIRECT, an additional option is "in-out" (0).}

\item{similarity}{matrix of similarities. In alternative to provide the exogenous variables, the matrix of similarities can be directly provided. This allow to customize the estimation of the similarities.}

\item{inclusion}{If inclusion = TRUE the unit under analysis is included in the reference set. So, no super efficient scores are allowed. By default inclusion = FALSE.}

\item{print}{If print = TRUE the number of the unit under evaluation is printed. In case of large sample the function could require some time, so it could be useful to control how many units have already been evaluated and which one still have to be evaluated. By default print = FALSE.}
}
\value{
If the parameter alpha is specified, the function returns a data frame with three numeric columns.
The first column is the vector representing the conditional DEA scores (eff);
the second column is the vector representing the lower bound of the condifence interval (ci_low);
the third column is the vector representing the upper bound of the confidence interval (Ci_up).
If alpha is not specified, the functions returns only the first column of the data frame (eff).
}
\description{
This function allows to compute Robust and Conditional DEA scores.
}
\examples{
#Example with a very small sample to decrease computational time.
          x1 <-runif(50, 50, 75)
          x2 <-runif(50, 30, 75)
          x <- cbind(x1, x2)
          e <- rnorm(50, 0, 36)
          a1 <- 0.4
          a2 <- 0.6
          y <- a1*x1 + a2*x2 + e
          z <- ifelse(rnorm(50, 0, 1)>0, 1, 0)

          #Conditional DEA
          c_DEA <- conditional_DEA(input = x, output = y, exogenous = z,
                                   m = 30, B = 50,
                                   RTS = "crs", ORIENTATION = "in")
          summary(c_DEA$eff)

          \donttest{#Example with bigger sample
          x1 <-runif(100, 50, 75)
          x2 <-runif(100, 30, 75)
          x <- cbind(x1, x2)
          a1 <- 0.4
          a2 <- 0.6
          y <- a1*x1 + a2*x2
          z <- ifelse(rnorm(100, 0, 1)>0, 1, 0)

          #Conditional DEA
          c_DEA <- conditional_DEA(input = x, output = y, exogenous = z,
                                   m = 30, B = 50,
                                   RTS = "crs", ORIENTATION = "in")
          summary(c_DEA$eff)}

}
\concept{Conditional Data Envelopment Analysis}
