% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azimuth_image.R
\name{azimuth_image}
\alias{azimuth_image}
\title{Build azimuth image}
\usage{
azimuth_image(z, orientation = 0)
}
\arguments{
\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{orientation}{numeric vector of length one. Azimuth angle (in degrees)
corresponding to the direction at which the top of the image was pointing
when the picture was taken. This design follows the common field protocol
of recording the angle at which the top of the camera points.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} with the same dimensions as the input
zenith image. Each pixel contains the azimuth angle in degrees, with zero
representing North and angles increasing counter-clockwise. The
object carries attributes \code{orientation} and \code{lens_coef}.
}
\description{
Creates a single-layer raster in which pixel values represent azimuth
angles, assuming an upwards-looking hemispherical photograph with the
optical axis vertically aligned.
}
\note{
If \code{orientation = 0}, North (0 deg) is located at the top of the image, as in
conventional maps, but East (90 deg) and West (270 deg) appear flipped
relative to maps. To understand this, take two flash-card-sized pieces of
paper. Place one on a table in front of you and draw a compass rose on it.
Hold the other above your head, with the side facing down toward you, and
draw another compass rose following the directions from the one on the table.
This mimics the situation of taking an upwards-looking photo with a
smartphone while viewing the screen, and it will result in a mirrored
arrangement. Compare both drawings to see the inversion.
}
\examples{
z <- zenith_image(600, lens("Nikon_FCE9"))
a <- azimuth_image(z)
plot(a)
\dontrun{
a <- azimuth_image(z, 45)
plot(a)
}
}
