/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.stereo.Atropisomeric;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedCisTrans;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class AtomContainerManipulator {
    public static final int MolWeight = 1;
    public static final int MolWeightIgnoreSpecified = 2;
    public static final int MonoIsotopic = 3;
    public static final int MostAbundant = 4;
    public static final Comparator<IIsotope> NAT_ABUN_COMP = new Comparator<IIsotope>(){

        @Override
        public int compare(IIsotope o1, IIsotope o2) {
            return -Double.compare(o1.getNaturalAbundance(), o2.getNaturalAbundance());
        }
    };

    @Deprecated
    public static IAtomContainer extractSubstructure(IAtomContainer atomContainer, int ... atomIndices) throws CloneNotSupportedException {
        return AtomContainerManipulator.extractSubstructure(atomContainer, Arrays.stream(atomIndices).mapToObj(arg_0 -> ((IAtomContainer)atomContainer).getAtom(arg_0)).collect(Collectors.toSet()));
    }

    public static void copy(IAtomContainer dest, IAtomContainer source, Predicate<IAtom> atomFilter, Predicate<IBond> bondFilter) {
        IAtom newAtom;
        HashMap<Object, Object> remap = new HashMap<Object, Object>();
        for (IAtom atom : source.atoms()) {
            if (!atomFilter.test(atom)) continue;
            dest.addAtom(atom);
            remap.put(atom, dest.getAtom(dest.getAtomCount() - 1));
        }
        for (IBond bond : source.bonds()) {
            IAtom beg = (IAtom)remap.get(bond.getBegin());
            IAtom end = (IAtom)remap.get(bond.getEnd());
            if (beg == null || end == null || !bondFilter.test(bond)) continue;
            dest.addBond(dest.indexOf(beg), dest.indexOf(end), bond.getOrder(), bond.getStereo());
            IBond destBond = dest.getBond(dest.getBondCount() - 1);
            destBond.setIsInRing(bond.isInRing());
            destBond.setIsAromatic(bond.isAromatic());
            destBond.setProperties(bond.getProperties());
            remap.put(bond, destBond);
        }
        for (ISingleElectron se : source.singleElectrons()) {
            newAtom = (IAtom)remap.get(se.getAtom());
            if (newAtom == null) continue;
            dest.addSingleElectron(dest.indexOf(newAtom));
        }
        for (ILonePair lp : source.lonePairs()) {
            newAtom = (IAtom)remap.get(lp.getAtom());
            if (newAtom == null) continue;
            dest.addLonePair(dest.indexOf(newAtom));
        }
        for (IStereoElement sourceStereo : source.stereoElements()) {
            IStereoElement destStereo = sourceStereo.mapStrict(remap);
            if (destStereo == null) continue;
            dest.addStereoElement(destStereo);
        }
    }

    public static void copy(IAtomContainer dest, IAtomContainer source, Predicate<IAtom> atomFilter) {
        AtomContainerManipulator.copy(dest, source, atomFilter, b -> true);
    }

    public static void copy(IAtomContainer dest, IAtomContainer source, Collection<IAtom> atoms) {
        AtomContainerManipulator.copy(dest, source, atoms::contains, b -> true);
    }

    public static IAtomContainer extractSubstructure(IAtomContainer source, Collection<IAtom> atoms) {
        IAtomContainer dest = source.getBuilder().newAtomContainer();
        AtomContainerManipulator.copy(dest, source, atoms::contains, b -> true);
        return dest;
    }

    public static IAtom getAtomById(IAtomContainer ac, String id) throws CDKException {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getID() == null || !ac.getAtom(i).getID().equals(id)) continue;
            return ac.getAtom(i);
        }
        throw new CDKException("no suc atom");
    }

    public static boolean replaceAtomByAtom(IAtomContainer container, IAtom oldAtom, IAtom newAtom) {
        if (oldAtom == null) {
            throw new NullPointerException("Atom to be replaced was null!");
        }
        if (newAtom == null) {
            throw new NullPointerException("Replacement atom was null!");
        }
        int idx = container.indexOf(oldAtom);
        if (idx < 0) {
            return false;
        }
        container.setAtom(idx, newAtom);
        List sgrougs = (List)container.getProperty((Object)"cdk:CtabSgroups");
        if (sgrougs != null) {
            boolean updated = false;
            ArrayList<Sgroup> replaced = new ArrayList<Sgroup>();
            for (Sgroup org : sgrougs) {
                if (org.getAtoms().contains(oldAtom)) {
                    updated = true;
                    Sgroup cpy = new Sgroup();
                    for (IAtom atom : org.getAtoms()) {
                        if (!oldAtom.equals(atom)) {
                            cpy.addAtom(atom);
                            continue;
                        }
                        cpy.addAtom(newAtom);
                    }
                    for (IBond bond : org.getBonds()) {
                        cpy.addBond(bond);
                    }
                    for (Sgroup parent : org.getParents()) {
                        cpy.addParent(parent);
                    }
                    for (SgroupKey key : org.getAttributeKeys()) {
                        cpy.putValue(key, org.getValue(key));
                    }
                    replaced.add(cpy);
                    continue;
                }
                replaced.add(org);
            }
            if (updated) {
                container.setProperty((Object)"cdk:CtabSgroups", Collections.unmodifiableList(replaced));
            }
        }
        return true;
    }

    public static double getTotalCharge(IAtomContainer atomContainer) {
        double charge = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            Double thisCharge = atom.getCharge();
            if (thisCharge == CDKConstants.UNSET) continue;
            charge += thisCharge.doubleValue();
        }
        return charge;
    }

    private static boolean hasIsotopeSpecified(IIsotope atom) {
        return atom.getMassNumber() != null && atom.getMassNumber() != 0;
    }

    private static double getExactMass(IsotopeFactory isofact, IIsotope atom) {
        if (atom.getExactMass() != null) {
            return atom.getExactMass();
        }
        if (atom.getMassNumber() != null) {
            return isofact.getExactMass(Integer.valueOf(AtomContainerManipulator.getAtomicNum((IElement)atom)), atom.getMassNumber());
        }
        return isofact.getMajorIsotopeMass(AtomContainerManipulator.getAtomicNum((IElement)atom));
    }

    private static double getMassOrAvg(IsotopeFactory isofact, IIsotope atom) {
        if (!AtomContainerManipulator.hasIsotopeSpecified(atom)) {
            return isofact.getNaturalMass((IElement)atom);
        }
        return AtomContainerManipulator.getExactMass(isofact, atom);
    }

    private static double getDistMass(IsotopeFactory isofact, IIsotope[] isos, int idx, int count) {
        if (count == 0) {
            return 0.0;
        }
        double frac = 100.0;
        double res = 0.0;
        for (int i = 0; i < idx; ++i) {
            frac -= isos[i].getNaturalAbundance().doubleValue();
        }
        double p = isos[idx].getNaturalAbundance() / frac;
        if (p >= 1.0) {
            return (double)count * isos[idx].getExactMass();
        }
        double kMin = (double)(count + 1) * (1.0 - p) - 1.0;
        double kMax = (double)(count + 1) * (1.0 - p);
        if ((int)Math.ceil(kMin) == (int)Math.floor(kMax)) {
            int k = (int)kMax;
            res = (double)(count - k) * AtomContainerManipulator.getExactMass(isofact, isos[idx]);
            res += AtomContainerManipulator.getDistMass(isofact, isos, idx + 1, k);
        }
        return res;
    }

    private static int getImplHCount(IAtom atom) {
        Integer implh = atom.getImplicitHydrogenCount();
        if (implh == null) {
            throw new IllegalArgumentException("An atom had 'null' implicit hydrogens!");
        }
        return implh;
    }

    private static int getAtomicNum(IElement atom) {
        Integer atno = atom.getAtomicNumber();
        if (atno == null) {
            throw new IllegalArgumentException("An atom had 'null' atomic number!");
        }
        return atno;
    }

    public static double getMass(IAtomContainer mol, int flav) {
        Isotopes isofact;
        try {
            isofact = Isotopes.getInstance();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load Isotopes!");
        }
        double mass = 0.0;
        int hcnt = 0;
        switch (flav & 0xF) {
            case 1: {
                for (IAtom atom : mol.atoms()) {
                    mass += AtomContainerManipulator.getMassOrAvg((IsotopeFactory)isofact, (IIsotope)atom);
                    hcnt += AtomContainerManipulator.getImplHCount(atom);
                }
                mass += (double)hcnt * isofact.getNaturalMass(1);
                break;
            }
            case 2: {
                for (IAtom atom : mol.atoms()) {
                    mass += isofact.getNaturalMass(AtomContainerManipulator.getAtomicNum((IElement)atom));
                    hcnt += AtomContainerManipulator.getImplHCount(atom);
                }
                mass += (double)hcnt * isofact.getNaturalMass(1);
                break;
            }
            case 3: {
                for (IAtom atom : mol.atoms()) {
                    mass += AtomContainerManipulator.getExactMass((IsotopeFactory)isofact, (IIsotope)atom);
                    hcnt += AtomContainerManipulator.getImplHCount(atom);
                }
                mass += (double)hcnt * isofact.getMajorIsotopeMass(1);
                break;
            }
            case 4: {
                int[] mf = new int[128];
                for (IAtom atom : mol.atoms()) {
                    if (AtomContainerManipulator.hasIsotopeSpecified((IIsotope)atom)) {
                        mass += AtomContainerManipulator.getExactMass((IsotopeFactory)isofact, (IIsotope)atom);
                    } else {
                        int n = AtomContainerManipulator.getAtomicNum((IElement)atom);
                        mf[n] = mf[n] + 1;
                    }
                    mf[1] = mf[1] + atom.getImplicitHydrogenCount();
                }
                for (int atno = 0; atno < mf.length; ++atno) {
                    if (mf[atno] == 0) continue;
                    IIsotope[] isotopes = isofact.getIsotopes(atno);
                    Arrays.sort(isotopes, NAT_ABUN_COMP);
                    mass += AtomContainerManipulator.getDistMass((IsotopeFactory)isofact, isotopes, 0, mf[atno]);
                }
                break;
            }
        }
        return mass;
    }

    public static double getMass(IAtomContainer mol) {
        return AtomContainerManipulator.getMass(mol, 1);
    }

    public static double getTotalExactMass(IAtomContainer mol) {
        return AtomContainerManipulator.getMass(mol, 3);
    }

    public static double getNaturalExactMass(IAtomContainer mol) {
        return AtomContainerManipulator.getMass(mol, 2);
    }

    public static double getMolecularWeight(IAtomContainer mol) {
        return AtomContainerManipulator.getMass(mol, 1);
    }

    public static double getTotalNaturalAbundance(IAtomContainer atomContainer) {
        try {
            Isotopes isotopes = Isotopes.getInstance();
            double abundance = 1.0;
            double hAbundance = isotopes.getMajorIsotope(1).getNaturalAbundance();
            int nImplH = 0;
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getImplicitHydrogenCount() == null) {
                    throw new IllegalArgumentException("an atom had with unknown (null) implicit hydrogens");
                }
                abundance *= atom.getNaturalAbundance().doubleValue();
                for (int h = 0; h < atom.getImplicitHydrogenCount(); ++h) {
                    abundance *= hAbundance;
                }
                nImplH += atom.getImplicitHydrogenCount().intValue();
            }
            int acount = atomContainer.getAtomCount();
            return abundance / Math.pow(100.0, (double)nImplH + (double)acount);
        }
        catch (IOException e) {
            throw new RuntimeException("Isotopes definitions could not be loaded", e);
        }
    }

    public static int getTotalFormalCharge(IAtomContainer atomContainer) {
        int chargeP = AtomContainerManipulator.getTotalNegativeFormalCharge(atomContainer);
        int chargeN = AtomContainerManipulator.getTotalPositiveFormalCharge(atomContainer);
        return chargeP + chargeN;
    }

    public static int getTotalNegativeFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            int chargeI = atomContainer.getAtom(i).getFormalCharge();
            if (chargeI >= 0) continue;
            charge += chargeI;
        }
        return charge;
    }

    public static int getTotalPositiveFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            int chargeI = atomContainer.getAtom(i).getFormalCharge();
            if (chargeI <= 0) continue;
            charge += chargeI;
        }
        return charge;
    }

    public static int getTotalHydrogenCount(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("null container provided");
        }
        int hydrogens = 0;
        for (IAtom atom : container.atoms()) {
            Integer implicit;
            if (Elements.HYDROGEN.getAtomicNumber().equals(atom.getAtomicNumber())) {
                ++hydrogens;
            }
            if ((implicit = atom.getImplicitHydrogenCount()) == null) continue;
            hydrogens += implicit.intValue();
        }
        return hydrogens;
    }

    public static int getImplicitHydrogenCount(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("null container provided");
        }
        int count = 0;
        for (IAtom atom : container.atoms()) {
            Integer implicit = atom.getImplicitHydrogenCount();
            if (implicit == null) continue;
            count += implicit.intValue();
        }
        return count;
    }

    public static int countExplicitHydrogens(IAtomContainer atomContainer, IAtom atom) {
        if (atomContainer == null || atom == null) {
            throw new IllegalArgumentException("null container or atom provided");
        }
        int hCount = 0;
        for (IAtom connected : atomContainer.getConnectedAtomsList(atom)) {
            if (!Elements.HYDROGEN.getAtomicNumber().equals(connected.getAtomicNumber())) continue;
            ++hCount;
        }
        return hCount;
    }

    private static void replaceAtom(IAtom[] atoms, IAtom org, IAtom rep) {
        for (int i = 0; i < atoms.length; ++i) {
            if (!atoms[i].equals(org)) continue;
            atoms[i] = rep;
        }
    }

    public static void convertImplicitToExplicitHydrogens(IAtomContainer atomContainer) {
        ArrayList<IAtom> hydrogens = new ArrayList<IAtom>();
        ArrayList<IBond> newBonds = new ArrayList<IBond>();
        HashMap<IAtom, IAtom> hNeighbor = new HashMap<IAtom, IAtom>(2 * atomContainer.getAtomCount());
        for (IAtom atom : atomContainer.atoms()) {
            Integer hCount;
            if (atom.getAtomicNumber() == 1 || (hCount = atom.getImplicitHydrogenCount()) == null) continue;
            for (int i = 0; i < hCount; ++i) {
                IAtom hydrogen = (IAtom)atom.getBuilder().newInstance(IAtom.class, new Object[]{"H"});
                hydrogen.setAtomTypeName("H");
                hydrogen.setImplicitHydrogenCount(Integer.valueOf(0));
                hydrogens.add(hydrogen);
                newBonds.add((IBond)atom.getBuilder().newInstance(IBond.class, new Object[]{atom, hydrogen, IBond.Order.SINGLE}));
                if (hNeighbor.get(atom) != null) continue;
                hNeighbor.put(atom, hydrogen);
            }
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        for (IAtom atom : hydrogens) {
            atomContainer.addAtom(atom);
        }
        for (IBond bond : newBonds) {
            atomContainer.addBond(bond);
        }
        ArrayList<Object> stereos = new ArrayList<Object>();
        for (IStereoElement stereo : atomContainer.stereoElements()) {
            IAtom[] carriers;
            IAtom focus;
            ITetrahedralChirality tc;
            if (stereo instanceof ITetrahedralChirality) {
                tc = (ITetrahedralChirality)stereo;
                focus = (IAtom)tc.getFocus();
                carriers = tc.getCarriers().toArray(new IAtom[4]);
                IAtom hydrogen = (IAtom)hNeighbor.get(focus);
                if (hydrogen != null) {
                    AtomContainerManipulator.replaceAtom(carriers, focus, hydrogen);
                    TetrahedralChirality newStereo = new TetrahedralChirality(focus, carriers, tc.getStereo());
                    newStereo.setGroupInfo(tc.getGroupInfo());
                    stereos.add(newStereo);
                    continue;
                }
                stereos.add(stereo);
                continue;
            }
            if (stereo instanceof ExtendedTetrahedral) {
                tc = (ExtendedTetrahedral)stereo;
                focus = (IAtom)tc.getFocus();
                carriers = tc.getCarriers().toArray(new IAtom[4]);
                IAtom[] ends = ExtendedTetrahedral.findTerminalAtoms((IAtomContainer)atomContainer, (IAtom)focus);
                IAtom h1 = (IAtom)hNeighbor.get(ends[0]);
                IAtom h2 = (IAtom)hNeighbor.get(ends[1]);
                if (h1 != null || h2 != null) {
                    if (h1 != null) {
                        AtomContainerManipulator.replaceAtom(carriers, ends[0], h1);
                    }
                    if (h2 != null) {
                        AtomContainerManipulator.replaceAtom(carriers, ends[1], h2);
                    }
                    stereos.add(new ExtendedTetrahedral(focus, carriers, tc.getConfigOrder()));
                    continue;
                }
                stereos.add(stereo);
                continue;
            }
            stereos.add(stereo);
        }
        atomContainer.setStereoElements(stereos);
    }

    public static int countHydrogens(IAtomContainer atomContainer, IAtom atom) {
        int hCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        return hCount += AtomContainerManipulator.countExplicitHydrogens(atomContainer, atom);
    }

    public static List<String> getAllIDs(IAtomContainer mol) {
        ArrayList<String> idList = new ArrayList<String>();
        if (mol != null) {
            if (mol.getID() != null) {
                idList.add(mol.getID());
            }
            for (IAtom atom : mol.atoms()) {
                if (atom.getID() == null) continue;
                idList.add(atom.getID());
            }
            for (IBond bond : mol.bonds()) {
                if (bond.getID() == null) continue;
                idList.add(bond.getID());
            }
        }
        return idList;
    }

    public static IAtomContainer removeNonChiralHydrogens(IAtomContainer org) {
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer cpy = (IAtomContainer)org.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        int count = org.getAtomCount();
        for (int i = 0; i < count; ++i) {
            IAtom neighbour;
            Integer stereoParity;
            IAtom atom = org.getAtom(i);
            boolean addToRemove = false;
            if (AtomContainerManipulator.suppressibleHydrogen(org, atom) && org.getConnectedAtomsList(atom).size() == 1 && ((stereoParity = (neighbour = (IAtom)org.getConnectedAtomsList(atom).get(0)).getStereoParity()) == null || stereoParity == 0)) {
                addToRemove = true;
                for (IBond bond : org.getConnectedBondsList(neighbour)) {
                    IAtom neighboursNeighbour;
                    IBond.Stereo bondStereo = bond.getStereo();
                    if (bondStereo != null && bondStereo != IBond.Stereo.NONE) {
                        addToRemove = false;
                    }
                    if ((neighboursNeighbour = bond.getOther(neighbour)).getAtomicNumber() != 1 || neighboursNeighbour.equals(atom)) continue;
                    addToRemove = true;
                    break;
                }
            }
            if (addToRemove) {
                remove.add(atom);
                continue;
            }
            AtomContainerManipulator.addClone(atom, cpy, map);
        }
        for (IStereoElement stereoElement : org.stereoElements()) {
            if (stereoElement instanceof ITetrahedralChirality) {
                ITetrahedralChirality tetChirality = (ITetrahedralChirality)stereoElement;
                for (IAtom atom : tetChirality.getLigands()) {
                    if (atom.getAtomicNumber() != 1 || !remove.contains(atom)) continue;
                    remove.remove(atom);
                    AtomContainerManipulator.addClone(atom, cpy, map);
                }
                continue;
            }
            if (!(stereoElement instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbs = (IDoubleBondStereochemistry)stereoElement;
            IBond stereoBond = dbs.getStereoBond();
            for (IAtom neighbor : org.getConnectedAtomsList(stereoBond.getBegin())) {
                if (!remove.remove(neighbor)) continue;
                AtomContainerManipulator.addClone(neighbor, cpy, map);
            }
            for (IAtom neighbor : org.getConnectedAtomsList(stereoBond.getEnd())) {
                if (!remove.remove(neighbor)) continue;
                AtomContainerManipulator.addClone(neighbor, cpy, map);
            }
        }
        count = org.getBondCount();
        for (int i = 0; i < count; ++i) {
            IBond bond = org.getBond(i);
            boolean removedBond = false;
            int length = bond.getAtomCount();
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(bond.getAtom(k))) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            IBond clone = null;
            try {
                clone = org.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                LoggingToolFactory.createLoggingTool(AtomContainerManipulator.class).warn((Object)"Unexpected Error:", new Object[]{e});
            }
            assert (clone != null);
            clone.setAtoms(new IAtom[]{(IAtom)map.get(bond.getBegin()), (IAtom)map.get(bond.getEnd())});
            cpy.addBond(clone);
        }
        for (IAtom aRemove : remove) {
            for (IAtom iAtom : org.getConnectedAtomsList(aRemove)) {
                IAtom neighb = (IAtom)map.get(iAtom);
                if (neighb == null) continue;
                neighb.setImplicitHydrogenCount(Integer.valueOf((neighb.getImplicitHydrogenCount() == null ? 0 : neighb.getImplicitHydrogenCount()) + 1));
            }
        }
        for (IAtom atom : cpy.atoms()) {
            if (atom.getImplicitHydrogenCount() != null) continue;
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
        }
        cpy.addProperties(org.getProperties());
        cpy.setFlags(org.getFlags());
        return cpy;
    }

    private static void addClone(IAtom atom, IAtomContainer mol, Map<IAtom, IAtom> map) {
        IAtom clonedAtom = null;
        try {
            clonedAtom = atom.clone();
        }
        catch (CloneNotSupportedException e) {
            LoggingToolFactory.createLoggingTool(AtomContainerManipulator.class).warn((Object)"Unexpected Error:", new Object[]{e});
        }
        mol.addAtom(clonedAtom);
        map.put(atom, clonedAtom);
    }

    public static IAtomContainer copyAndSuppressedHydrogens(IAtomContainer org) {
        try {
            return AtomContainerManipulator.suppressHydrogens(org.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("atom container could not be cloned");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static IAtomContainer suppressHydrogens(IAtomContainer org) {
        HashSet<Object> remove;
        boolean anyHydrogenPresent = false;
        for (IAtom atom : org.atoms()) {
            if (atom.getAtomicNumber() != 1) continue;
            anyHydrogenPresent = true;
            break;
        }
        if (!anyHydrogenPresent) {
            return org;
        }
        Set xatoms = Collections.emptySet();
        Collection sgroups = (Collection)org.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups != null) {
            xatoms = new HashSet();
            for (Sgroup sgroup : sgroups) {
                for (IBond bond : sgroup.getBonds()) {
                    xatoms.add(bond.getBegin());
                    xatoms.add(bond.getEnd());
                }
            }
        }
        GraphUtil.EdgeToBondMap bondmap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)org);
        int[][] graph = GraphUtil.toAdjList((IAtomContainer)org, (GraphUtil.EdgeToBondMap)bondmap);
        int nOrgAtoms = org.getAtomCount();
        int nOrgBonds = org.getBondCount();
        int nCpyAtoms = 0;
        int nCpyBonds = 0;
        HashSet<IAtom> hydrogens = new HashSet<IAtom>(nOrgAtoms);
        HashSet<Object> bondsToHydrogens = new HashSet<Object>();
        IAtom[] cpyAtoms = new IAtom[nOrgAtoms];
        for (int v = 0; v < nOrgAtoms; ++v) {
            IAtom atom = org.getAtom(v);
            if (AtomContainerManipulator.suppressibleHydrogen(org, graph, bondmap, v) && !xatoms.contains(atom)) {
                hydrogens.add(atom);
                AtomContainerManipulator.incrementImplHydrogenCount(org.getAtom(graph[v][0]));
                continue;
            }
            cpyAtoms[nCpyAtoms++] = atom;
        }
        if (hydrogens.isEmpty()) {
            return org;
        }
        IBond[] cpyBonds = new IBond[nOrgBonds - hydrogens.size()];
        int remaining = hydrogens.size();
        for (Object bond : org.bonds()) {
            if (remaining > 0 && (hydrogens.contains(bond.getBegin()) || hydrogens.contains(bond.getEnd()))) {
                bondsToHydrogens.add(bond);
                --remaining;
                continue;
            }
            cpyBonds[nCpyBonds++] = bond;
        }
        if (nCpyBonds != cpyBonds.length) {
            throw new IllegalArgumentException("number of removed bonds was less than the number of removed hydrogens");
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object se : org.stereoElements()) {
            if (se instanceof ITetrahedralChirality) {
                ITetrahedralChirality iTetrahedralChirality = (ITetrahedralChirality)se;
                IAtom iAtom = iTetrahedralChirality.getChiralAtom();
                IAtom[] neighbors = iTetrahedralChirality.getLigands();
                boolean updated = false;
                for (int i = 0; i < neighbors.length; ++i) {
                    if (!hydrogens.contains(neighbors[i])) continue;
                    neighbors[i] = iAtom;
                    updated = true;
                }
                if (!updated) {
                    elements.add(iTetrahedralChirality);
                    continue;
                }
                TetrahedralChirality e = new TetrahedralChirality(iAtom, neighbors, iTetrahedralChirality.getStereo());
                e.setGroupInfo(iTetrahedralChirality.getGroupInfo());
                elements.add(e);
                continue;
            }
            if (se instanceof ExtendedTetrahedral) {
                ExtendedTetrahedral extendedTetrahedral = (ExtendedTetrahedral)se;
                IAtom iAtom = (IAtom)extendedTetrahedral.getFocus();
                IAtom[] carriers = extendedTetrahedral.getCarriers().toArray(new IAtom[4]);
                IAtom[] ends = ExtendedTetrahedral.findTerminalAtoms((IAtomContainer)org, (IAtom)iAtom);
                boolean updated = false;
                for (int i = 0; i < carriers.length; ++i) {
                    if (!hydrogens.contains(carriers[i])) continue;
                    carriers[i] = org.getBond(carriers[i], ends[0]) != null ? ends[0] : ends[1];
                    updated = true;
                }
                if (!updated) {
                    elements.add(extendedTetrahedral);
                    continue;
                }
                elements.add(new ExtendedTetrahedral(iAtom, carriers, extendedTetrahedral.getConfigOrder()));
                continue;
            }
            if (se instanceof IDoubleBondStereochemistry) {
                void var19_46;
                IDoubleBondStereochemistry iDoubleBondStereochemistry = (IDoubleBondStereochemistry)se;
                IDoubleBondStereochemistry.Conformation conformation = iDoubleBondStereochemistry.getStereo();
                IBond orgStereo = iDoubleBondStereochemistry.getStereoBond();
                IBond orgLeft = iDoubleBondStereochemistry.getBonds()[0];
                IBond orgRight = iDoubleBondStereochemistry.getBonds()[1];
                IAtom u = orgStereo.getBegin();
                IAtom v = orgStereo.getEnd();
                IAtom x = orgLeft.getOther(u);
                IAtom y = orgRight.getOther(v);
                IAtom xNew = x;
                IAtom yNew = y;
                if (hydrogens.contains(x)) {
                    IDoubleBondStereochemistry.Conformation conformation2 = conformation.invert();
                    xNew = AtomContainerManipulator.findSingleBond(org, u, x);
                }
                if (hydrogens.contains(y)) {
                    void var19_44;
                    IDoubleBondStereochemistry.Conformation conformation3 = var19_44.invert();
                    yNew = AtomContainerManipulator.findSingleBond(org, v, y);
                }
                if (x == null || y == null || xNew == null || yNew == null) continue;
                if (x.equals(xNew) && y.equals(yNew)) {
                    elements.add(iDoubleBondStereochemistry);
                    continue;
                }
                IBond cpyLeft = !Objects.equals(xNew, x) ? org.getBond(u, xNew) : orgLeft;
                IBond cpyRight = !Objects.equals(yNew, y) ? org.getBond(v, yNew) : orgRight;
                elements.add(new DoubleBondStereochemistry(orgStereo, new IBond[]{cpyLeft, cpyRight}, (IDoubleBondStereochemistry.Conformation)var19_46));
                continue;
            }
            if (se instanceof ExtendedCisTrans) {
                int n;
                int n2;
                ExtendedCisTrans extendedCisTrans = (ExtendedCisTrans)se;
                int n3 = extendedCisTrans.getConfigOrder();
                IBond focus = (IBond)extendedCisTrans.getFocus();
                IBond orgLeft = (IBond)extendedCisTrans.getCarriers().get(0);
                IBond orgRight = (IBond)extendedCisTrans.getCarriers().get(1);
                IAtom[] ends = ExtendedCisTrans.findTerminalAtoms((IAtomContainer)org, (IBond)focus);
                IAtom u = ends[0];
                IAtom v = ends[1];
                IAtom x = orgLeft.getOther(u);
                IAtom y = orgRight.getOther(v);
                IAtom xNew = x;
                IAtom yNew = y;
                if (hydrogens.contains(x)) {
                    n2 = n3 ^ 3;
                    xNew = AtomContainerManipulator.findSingleBond(org, u, x);
                }
                if (hydrogens.contains(y)) {
                    n = n2 ^ 3;
                    yNew = AtomContainerManipulator.findSingleBond(org, v, y);
                }
                if (x == null || y == null || xNew == null || yNew == null) continue;
                if (x.equals(xNew) && y.equals(yNew)) {
                    elements.add(extendedCisTrans);
                    continue;
                }
                IBond cpyLeft = !Objects.equals(xNew, x) ? org.getBond(u, xNew) : orgLeft;
                IBond cpyRight = !Objects.equals(yNew, y) ? org.getBond(v, yNew) : orgRight;
                elements.add(new ExtendedCisTrans(focus, new IBond[]{cpyLeft, cpyRight}, n));
                continue;
            }
            if (!(se instanceof Atropisomeric)) continue;
            elements.add(se);
        }
        org.setAtoms(Arrays.copyOf(cpyAtoms, nCpyAtoms));
        org.setBonds(cpyBonds);
        org.setStereoElements(elements);
        if (org.getSingleElectronCount() > 0) {
            remove = new HashSet<Object>();
            for (ISingleElectron iSingleElectron : org.singleElectrons()) {
                if (!hydrogens.contains(iSingleElectron.getAtom())) continue;
                remove.add(iSingleElectron);
            }
            for (ISingleElectron iSingleElectron : remove) {
                org.removeSingleElectron(iSingleElectron);
            }
        }
        if (org.getLonePairCount() > 0) {
            remove = new HashSet();
            for (ILonePair iLonePair : org.lonePairs()) {
                if (!hydrogens.contains(iLonePair.getAtom())) continue;
                remove.add(iLonePair);
            }
            for (ILonePair iLonePair : remove) {
                org.removeLonePair(iLonePair);
            }
        }
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                if (sgroup.getValue(SgroupKey.CtabParentAtomList) != null) {
                    Collection collection = (Collection)sgroup.getValue(SgroupKey.CtabParentAtomList);
                    collection.removeAll(hydrogens);
                }
                for (IAtom iAtom : hydrogens) {
                    sgroup.removeAtom(iAtom);
                }
                for (IBond iBond : bondsToHydrogens) {
                    sgroup.removeBond(iBond);
                }
            }
            org.setProperty((Object)"cdk:CtabSgroups", (Object)sgroups);
        }
        return org;
    }

    public static IAtomContainer removeHydrogens(IAtomContainer org) {
        return AtomContainerManipulator.copyAndSuppressedHydrogens(org);
    }

    private static boolean suppressibleHydrogen(IAtomContainer container, IAtom atom) {
        if (atom.getAtomicNumber() != 1) {
            return false;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return false;
        }
        if (atom.getMassNumber() != null) {
            return false;
        }
        if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() != 0) {
            return false;
        }
        List neighbors = container.getConnectedAtomsList(atom);
        return neighbors.size() != 1 || ((IAtom)neighbors.get(0)).getAtomicNumber() != 1 && !(neighbors.get(0) instanceof IPseudoAtom);
    }

    private static void incrementImplHydrogenCount(IAtom atom) {
        Integer hCount = atom.getImplicitHydrogenCount();
        if (hCount == null) {
            if (!(atom instanceof IPseudoAtom)) {
                throw new IllegalArgumentException("a non-pseudo atom had an unset hydrogen count");
            }
            hCount = 0;
        }
        atom.setImplicitHydrogenCount(Integer.valueOf(hCount + 1));
    }

    private static boolean suppressibleHydrogen(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondmap, int v) {
        IAtom atom = container.getAtom(v);
        if (atom.getAtomicNumber() != 1) {
            return false;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return false;
        }
        if (atom.getMassNumber() != null) {
            return false;
        }
        if (graph[v].length != 1) {
            return false;
        }
        if (bondmap.get(v, graph[v][0]).getOrder() != IBond.Order.SINGLE) {
            return false;
        }
        if (container.getAtom(graph[v][0]).getAtomicNumber() == 1) {
            return false;
        }
        return !(container.getAtom(graph[v][0]) instanceof IPseudoAtom);
    }

    private static IAtom findSingleBond(IAtomContainer container, IAtom atom, IAtom exclude) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IAtom neighbor;
            if (bond.getOrder() != IBond.Order.SINGLE || (neighbor = bond.getOther(atom)).equals(exclude)) continue;
            return neighbor;
        }
        return null;
    }

    @Deprecated
    public static IAtomContainer removeHydrogensPreserveMultiplyBonded(IAtomContainer ac) {
        return AtomContainerManipulator.copyAndSuppressedHydrogens(ac);
    }

    @Deprecated
    private static IAtomContainer removeHydrogens(IAtomContainer ac, List<IAtom> preserve) {
        int i;
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer mol = (IAtomContainer)ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        int count = ac.getAtomCount();
        for (i = 0; i < count; ++i) {
            IAtom atom = ac.getAtom(i);
            if (!AtomContainerManipulator.suppressibleHydrogen(ac, atom) || preserve.contains(atom)) {
                IAtom a = null;
                try {
                    a = atom.clone();
                    a.setImplicitHydrogenCount(Integer.valueOf(0));
                    mol.addAtom(a);
                    map.put(atom, a);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    throw new IllegalStateException("Could nod clone atom", e);
                }
            }
            remove.add(atom);
        }
        count = ac.getBondCount();
        for (i = 0; i < count; ++i) {
            IBond bond = ac.getBond(i);
            IAtom atom0 = bond.getBegin();
            IAtom atom1 = bond.getEnd();
            boolean remove_bond = false;
            for (IAtom atom : bond.atoms()) {
                if (!remove.contains(atom)) continue;
                remove_bond = true;
                break;
            }
            if (remove_bond) continue;
            IBond clone = null;
            try {
                clone = ac.getBond(i).clone();
                clone.setAtoms(new IAtom[]{(IAtom)map.get(atom0), (IAtom)map.get(atom1)});
                mol.addBond(clone);
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Could nod clone bond", e);
            }
        }
        for (IAtom removeAtom : remove) {
            for (IAtom neighbor : ac.getConnectedAtomsList(removeAtom)) {
                IAtom neighb = (IAtom)map.get(neighbor);
                neighb.setImplicitHydrogenCount(Integer.valueOf(neighb.getImplicitHydrogenCount() + 1));
            }
        }
        return mol;
    }

    public static void setAtomProperties(IAtomContainer container, Object propKey, Object propVal) {
        if (container != null) {
            for (IAtom atom : container.atoms()) {
                atom.setProperty(propKey, propVal);
            }
        }
    }

    public static void unregisterElectronContainerListeners(IAtomContainer container) {
        for (IElectronContainer electronContainer : container.electronContainers()) {
            electronContainer.removeListener((IChemObjectListener)container);
        }
    }

    public static void unregisterAtomListeners(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.removeListener((IChemObjectListener)container);
        }
    }

    public static IAtomContainer getIntersection(IAtomContainer container1, IAtomContainer container2) {
        int i;
        IAtomContainer intersection = (IAtomContainer)container1.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (i = 0; i < container1.getAtomCount(); ++i) {
            if (!container2.contains(container1.getAtom(i))) continue;
            intersection.addAtom(container1.getAtom(i));
        }
        for (i = 0; i < container1.getElectronContainerCount(); ++i) {
            if (!container2.contains(container1.getElectronContainer(i))) continue;
            intersection.addElectronContainer(container1.getElectronContainer(i));
        }
        return intersection;
    }

    public static IAtom[] getAtomArray(IAtomContainer container) {
        IAtom[] ret = new IAtom[container.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getAtom(i);
        }
        return ret;
    }

    public static IAtom[] getAtomArray(List<IAtom> list) {
        IAtom[] ret = new IAtom[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IBond[] getBondArray(IAtomContainer container) {
        IBond[] ret = new IBond[container.getBondCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getBond(i);
        }
        return ret;
    }

    public static IBond[] getBondArray(List<IBond> list) {
        IBond[] ret = new IBond[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(IAtomContainer container) {
        IElectronContainer[] ret = new IElectronContainer[container.getElectronContainerCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getElectronContainer(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(List<IElectronContainer> list) {
        IElectronContainer[] ret = new IElectronContainer[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configure(atom, matched);
        }
    }

    public static void percieveAtomTypesAndConfigureUnsetProperties(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configureUnsetProperties(atom, matched);
        }
    }

    public static void clearAtomConfigurations(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.setAtomTypeName((String)CDKConstants.UNSET);
            atom.setMaxBondOrder((IBond.Order)CDKConstants.UNSET);
            atom.setBondOrderSum((Double)CDKConstants.UNSET);
            atom.setCovalentRadius((Double)CDKConstants.UNSET);
            atom.setValency((Integer)CDKConstants.UNSET);
            atom.setFormalCharge((Integer)CDKConstants.UNSET);
            atom.setHybridization((IAtomType.Hybridization)CDKConstants.UNSET);
            atom.setFormalNeighbourCount((Integer)CDKConstants.UNSET);
            atom.setFlag(512, false);
            atom.setFlag(256, false);
            atom.setProperty((Object)"cdk:Chemical Group", CDKConstants.UNSET);
            atom.setFlag(32, false);
            atom.setProperty((Object)"org.openscience.cdk.renderer.color", CDKConstants.UNSET);
            atom.setExactMass((Double)CDKConstants.UNSET);
        }
    }

    public static int getSingleBondEquivalentSum(IAtomContainer container) {
        int sum = 0;
        for (IBond bond : container.bonds()) {
            IBond.Order order = bond.getOrder();
            if (order == null) continue;
            sum += order.numeric().intValue();
        }
        return sum;
    }

    public static IBond.Order getMaximumBondOrder(IAtomContainer container) {
        return BondManipulator.getMaximumBondOrder(container.bonds().iterator());
    }

    public static List<IAtom> getHeavyAtoms(IAtomContainer container) {
        ArrayList<IAtom> newAc = new ArrayList<IAtom>();
        for (int f = 0; f < container.getAtomCount(); ++f) {
            if (container.getAtom(f).getAtomicNumber() == 1) continue;
            newAc.add(container.getAtom(f));
        }
        return newAc;
    }

    public static IAtomContainer createAllCarbonAllSingleNonAromaticBondAtomContainer(IAtomContainer atomContainer) throws CloneNotSupportedException {
        IAtomContainer query = atomContainer.clone();
        for (int i = 0; i < query.getBondCount(); ++i) {
            query.getBond(i).setOrder(IBond.Order.SINGLE);
            query.getBond(i).setFlag(32, false);
            query.getBond(i).setFlag(4096, false);
            query.getBond(i).getBegin().setSymbol("C");
            query.getBond(i).getBegin().setHybridization(null);
            query.getBond(i).getEnd().setSymbol("C");
            query.getBond(i).getEnd().setHybridization(null);
            query.getBond(i).getBegin().setFlag(32, false);
            query.getBond(i).getEnd().setFlag(32, false);
        }
        return query;
    }

    public static IAtomContainer anonymise(IAtomContainer src) {
        int i;
        IChemObjectBuilder builder = src.getBuilder();
        IAtom[] atoms = new IAtom[src.getAtomCount()];
        IBond[] bonds = new IBond[src.getBondCount()];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = builder.newAtom();
            atoms[i].setAtomicNumber(Integer.valueOf(6));
            atoms[i].setSymbol("C");
            atoms[i].setImplicitHydrogenCount(Integer.valueOf(0));
            IAtom srcAtom = src.getAtom(i);
            if (srcAtom.getPoint2d() != null) {
                atoms[i].setPoint2d(new Point2d(srcAtom.getPoint2d()));
            }
            if (srcAtom.getPoint3d() == null) continue;
            atoms[i].setPoint3d(new Point3d(srcAtom.getPoint3d()));
        }
        for (i = 0; i < bonds.length; ++i) {
            IBond bond = src.getBond(i);
            int u = src.indexOf(bond.getBegin());
            int v = src.indexOf(bond.getEnd());
            bonds[i] = (IBond)builder.newInstance(IBond.class, new Object[]{atoms[u], atoms[v]});
        }
        IAtomContainer dest = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
        dest.setAtoms(atoms);
        dest.setBonds(bonds);
        return dest;
    }

    public static IAtomContainer skeleton(IAtomContainer src) {
        int i;
        IChemObjectBuilder builder = src.getBuilder();
        IAtom[] atoms = new IAtom[src.getAtomCount()];
        IBond[] bonds = new IBond[src.getBondCount()];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = (IAtom)builder.newInstance(IAtom.class, new Object[]{src.getAtom(i).getAtomicNumber()});
        }
        for (i = 0; i < bonds.length; ++i) {
            IBond bond = src.getBond(i);
            int u = src.indexOf(bond.getBegin());
            int v = src.indexOf(bond.getEnd());
            bonds[i] = (IBond)builder.newInstance(IBond.class, new Object[]{atoms[u], atoms[v]});
        }
        IAtomContainer dest = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
        dest.setAtoms(atoms);
        dest.setBonds(bonds);
        return dest;
    }

    public static double getBondOrderSum(IAtomContainer container, IAtom atom) {
        double count = 0.0;
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IBond.Order order = bond.getOrder();
            if (order == null) continue;
            count += (double)order.numeric().intValue();
        }
        return count;
    }

    public static IAtomContainer setSingleOrDoubleFlags(IAtomContainer ac) {
        RingSearch rs = new RingSearch(ac);
        boolean singleOrDouble = false;
        for (IBond bond : rs.ringFragments().bonds()) {
            if (!bond.getFlag(32)) continue;
            bond.setFlag(4096, true);
            bond.getBegin().setFlag(4096, true);
            bond.getEnd().setFlag(4096, true);
            singleOrDouble |= true;
        }
        if (singleOrDouble) {
            ac.setFlag(4096, true);
        }
        return ac;
    }
}

