% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{combine_query_boolean.aurum}
\alias{combine_query_boolean.aurum}
\title{Combine a CPRD aurum database query with a cohort returning a 0/1 vector depending on whether each individual has a recorded code of interest.}
\usage{
\method{combine_query_boolean}{aurum}(
  db_query,
  cohort,
  query_type,
  time_prev = Inf,
  time_post = 0,
  numobs = 1
)
}
\arguments{
\item{db_query}{Output from database query (ideally obtained through \code{\link{db_query}}).}

\item{cohort}{Cohort to combine with the database query.}

\item{query_type}{Type of query}

\item{time_prev}{Number of days prior to index date to look for codes.}

\item{time_post}{Number of days after index date to look for codes.}

\item{numobs}{Number of observations required to be observed in specified time window to return a 1.}
}
\value{
A 0/1 vector.
}
\description{
An S3 method that can be used on database queries from Aurum extracts. Combine a database query with a cohort returning a 0/1 vector depending on whether each individual has a recorded code of interest.
\code{cohort} must contain variables \code{patid} and \code{indexdt}. The database query will be merged with the cohort by variable \code{patid}.
If an individual has at least \code{numobs} observations between \code{time_prev} days prior to \code{indexdt}, and \code{time_post} days after
\code{indexdt}, a 1 will be returned, 0 otherwise. The \code{type} of query must be specified for appropriate data manipulation.
}
\examples{
## Create connection to a temporary database
aurum_extract <- connect_database(file.path(tempdir(), "temp.sqlite"))

## Add observation data from all observation files in specified directory
cprd_extract(db = aurum_extract,
filepath = system.file("aurum_data", package = "rcprd"),
filetype = "observation")

## Query database for a specific medcode
db_query <- db_query(db_open = aurum_extract,
tab ="observation",
codelist_vector = "187341000000114")

## Define cohort
pat<-extract_cohort(filepath = system.file("aurum_data", package = "rcprd"))

### Add an index date to pat
pat$indexdt <- as.Date("01/01/2020", format = "\%d/\%m/\%Y")

## Combine query with cohort retaining most recent three records
combine_query_boolean(cohort = pat,
db_query = db_query,
query_type = "med",
numobs = 3)

## clean up
RSQLite::dbDisconnect(aurum_extract)
unlink(file.path(tempdir(), "temp.sqlite"))

}
