% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locMap.R
\name{ddi_dataItem}
\alias{ddi_dataItem}
\alias{ddi_CubeCoord}
\alias{ddi_physLoc}
\title{dataItem and its child nodes}
\usage{
ddi_dataItem(...)

ddi_CubeCoord(...)

ddi_physLoc(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Identifies a physical storage location for an individual data entry, serving
as a link between the physical location and the logical content description
of each data item. . It is used to describe the physical location of
aggregate/tabular data in cases where the nCube model is employed. More
information on these elements, especially their allowed attributes, can be
found in the references.
}
\details{
\emph{Parent nodes}

\code{dataItem} is contained in \code{locMap}.

\emph{dataItem specific child nodes}
\itemize{
\item \code{ddi_CubeCoord()} is an empty element containing only the attributes
listed below. It is used to identify the coordinates of the data item within
a logical nCube describing aggregate data. CubeCoord is repeated for each
dimension of the nCube giving the coordinate number ("coordNo") and coordinate
value ("coordVal"). Coordinate value reference ("cordValRef") is an ID
reference to the variable that carries the coordinate value. The attributes
provide a complete coordinate location of a cell within the nCube.
\item \code{ddi_physLoc()} is an empty element containing only the attributes listed
below. Attributes include "type" (type of file structure: rectangular,
hierarchical, two-dimensional, relational), "recRef" (IDREF link to the
appropriate file or recGrp element within a file), "startPos" (starting
position of variable or data item), "endPos" (ending position of variable or
data item), "width" (number of columns the variable/data item occupies),
"RecSegNo" (the record segment number, deck or card number the variable or
data item is located on), and "fileid" (an IDREF link to the fileDscr
element for the file that includes this physical location).
}
}
\examples{
ddi_dataItem()

# Functions that need to be wrapped in ddi_dataItem()

ddi_CubeCoord(coordNo = "1", coordVal = "3")

ddi_physLoc(type = "rectangular", 
            recRef = "R1",
            startPos = "55",
            endPos = "57",
            width = "3")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/dataItem.html}{dataItem documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/CubeCoord.html}{CubeCoord documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/physLoc.html}{physLoc documentation}
}
