% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{validate_codebook}
\alias{validate_codebook}
\title{Validate generated codebook against DDI Codebook 2.5}
\usage{
validate_codebook(codebook)
}
\arguments{
\item{codebook}{The codebook root node, output of \code{ddi_codeBook()}.}
}
\value{
A logical (with attributes containing any errors) that indicates passing or failing.
}
\description{
Validates your constructed codebook against the
DDI Codebook 2.5 schema. While all built-in \code{ddi_} functions
are written with the schema in mind, this is useful
if you create your own DDI nodes (there are many and
it will take a while to implement all of them).
}
\examples{
cb <- ddi_codeBook(ddi_stdyDscr(ddi_citation(ddi_titlStmt(ddi_titl("Sample")))))
validate_codebook(cb)

}
