% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burn_in.R
\name{burn_in}
\alias{burn_in}
\title{Burn in streams to a digital elevation model}
\usage{
burn_in(dem, stream, out, burn = 10, overwrite = FALSE)
}
\arguments{
\item{dem}{Digital elevation model raster in the GRASS mapset.}

\item{stream}{Binary stream raster in the GRASS mapset.}

\item{out}{Name of output to be created in the GRASS mapset.}

\item{burn}{The magnitude of the drainage reinforcement in elevation units. Defaults to \code{10} elevation units.}

\item{overwrite}{A logical indicating whether the file \code{out} should be overwritten in the mapset and on disk. Defaults to \code{FALSE}.}
}
\value{
Nothing. A raster with the name \code{out} will be written to the current GRASS mapset.
}
\description{
Burning-in streams (also called 'drainage reinforcement') ensures flow direction and accumulation grids based on the digital elevation model will correctly identify the stream path.
}
\examples{
# Will only run if a GRASS session is initialised
if(check_running()){
# Load data set
dem <- system.file("extdata", "dem.tif", package = "rdwplus")
stream_shp <- system.file("extdata", "streams.shp", package = "rdwplus")
set_envir(dem)
raster_to_mapset(dem)
vector_to_mapset(stream_shp)

# Create binary stream
rasterise_stream("streams", "streams_rast")
reclassify_streams("streams_rast", "streams_binary", out_type = "binary")

# Burn dem 
burn_in(dem = "dem.tif", stream = "streams_binary", 
out = "dem_burn", burn = 10, overwrite = FALSE)

# Plot
plot_GRASS("dem_burn", col = topo.colors(10))
}
}
