% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{nytimes}
\alias{nytimes}
\title{Theme nytimes}
\usage{
nytimes(
  font_size = 13,
  font_color = "#333333",
  header_font_size = 11,
  header_font_color = "#999999",
  cell_padding = 5,
  centered = FALSE
)
}
\arguments{
\item{font_size}{Numeric value representing the size of the font within the table (in px).
Default is 13.}

\item{font_color}{Color of the font for the text within the table and the group headers.
Default is #333333.}

\item{header_font_size}{Numeric value representing the size of the font within the table (in px).
Default is 11.}

\item{header_font_color}{Color of the font for the header text.
Default is #999999.}

\item{cell_padding}{Numeric value representing the padding size between cells (in px).
Default is 5.}

\item{centered}{Logical: vertically center the contents of the table.
Default is FALSE.}
}
\value{
an object of class theme that is applied to a reactable table.
}
\description{
The New York Times-inspired table theme
}
\examples{
data <- iris[10:29, ]

## Standard nytimes theme
reactable(data,
          theme = nytimes())

## Additional options applied
reactable(data,
          theme = nytimes(font_size = 12, font_color = "grey", cell_padding = 3))

}
