% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_agfd_stars.R
\name{read_agfd_stars}
\alias{read_agfd_stars}
\title{Read ABARES' "Australian Gridded Farm Data" (AGFD) NCDF files with stars}
\usage{
read_agfd_stars(yyyy = 1991:2003, fixed_prices = TRUE, x = NULL)
}
\arguments{
\item{yyyy}{Returns only data for the specified year or years for climate
data (fixed prices) or the years for historical climate and prices depending
upon the setting of \code{fixed_prices}.  Note that this will still download the
entire data set, that cannot be avoided, but will only return the
requested year(s) in your \R session.  Valid years are from 1991 to 2023
inclusive.}

\item{fixed_prices}{Download historical climate and prices or historical
climate and fixed prices as described in  (Hughes \emph{et al.} 2022). Defaults
to \code{TRUE} and downloads the data with historical climate and fixed prices
"to isolate the effects of climate variability on financial incomes
for broadacre farm businesses" (ABARES 2024).  Using \code{TRUE} will download
simulations where global output and input price indexes are fixed at values
from the most recently completed financial year.}

\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \code{list} object of \CRANpkg{stars} objects of the "Australian
Gridded Farm Data" with the NetCDF objects' names as "year_yyyy".
}
\description{
Read "Australian Gridded Farm Data", (\acronym{AGFD}), as a list of
\CRANpkg{stars} objects.
}
\details{
From the \href{https://www.agriculture.gov.au/abares/research-topics/surveys/farm-survey-data/australian-gridded-farm-data}{ABARES website}:
"The Australian Gridded Farm Data (\acronym{AGFD}) are a set of national
scale maps containing simulated data on historical broadacre farm business
outcomes including farm profitability on an 0.05-degree (approximately 5 km)
grid.\cr
These data have been produced by \acronym{ABARES} as part of the ongoing
Australian Agricultural Drought Indicator (\acronym{AADI}) project
(previously known as the Drought Early Warning System Project) and were
derived using \acronym{ABARES}
\href{https://www.agriculture.gov.au/abares/research-topics/climate/drought/farmpredict}{\emph{farmpredict}}
model, which in turn is based on ABARES Agricultural and Grazing Industries
Survey (\acronym{AAGIS}) data.\cr
\href{https://www.agriculture.gov.au/abares/research-topics/climate/australian-agricultural-drought-indicators-project}{Australian Agricultural Drought Indicator}
(\acronym{AADI}) project (previously known as the Drought Early Warning
System Project) and were derived using \acronym{ABARES}
\href{https://www.agriculture.gov.au/abares/research-topics/climate/drought/farmpredict}{\emph{farmpredict}}
model, which in turn is based on ABARES \href{https://www.agriculture.gov.au/abares/research-topics/surveys/farm-definitions-methods}{Agricultural and Grazing Industries Survey}
(\acronym{AAGIS}) data.\cr
These maps provide estimates of farm business profit, revenue, costs and
production by location (grid cell) and year for the period 1990-91 to
2022-23. The data do not include actual observed outcomes but rather model
predicted outcomes for representative or 'typical' broadacre farm
businesses at each location considering likely farm characteristics and
prevailing weather conditions and commodity prices."\cr
-- \acronym{ABARES}, 2024-11-25

If you have not already downloaded the files, both sets of data are large in
file size, \emph{i.e.}, >1GB, and will require time to download.
}
\section{Model scenarios}{

\subsection{Historical Climate (fixed prices)}{

The Historical Climate (fixed prices) scenario is similar to that described
in Hughes \emph{et al.} (2022) and is intended to isolate the effects of climate
variability on financial incomes for broadacre farm businesses. In these
simulations, global output and input price indexes are fixed at values from
the most recently completed financial year. However, in these scenarios the
spread between domestic and global grain (wheat, barley and sorghum) prices,
along with Australian fodder prices are allowed to vary in response to
climate data (to capture domestic increases in grain and fodder prices in
drought years, see Hughes \emph{et al.} 2022). A 33-year historical climate
sequence (including historical simulated crop and pasture data from the
\acronym{AADI} project) is simulated for each grid cell (1990-91 to
2022-23).
}

\subsection{Historical Climate and Prices}{

As part of the \acronym{AADI} project an additional scenario was developed
accounting for changes in both climate conditions and output and input
prices (\emph{i.e.}, global commodity market variability). In this historical
climate and prices scenario the 33-year reference period allows for
variation in both historical climate conditions and historical prices. For
this scenario, historical price indexes were de-trended, to account for
consistent long-term trends in some real commodity prices (particularly
sheep and lamb). The resulting simulation results and percentile indicators
are intended to reflect the combined impacts of annual climate and commodity
price variability."

-- Taken from  \cite{Australian Bureau of Agricultural and Resource
Economics and Sciences (2024)}
}
}

\section{Data files}{


Simulation output data are saved as multilayer NetCDF files, which are named
using following convention:

\var{f<farm year>.c<climate year>.p<price year>.t<technology year>.nc}

where:
\itemize{
\item \var{<farm year>} = Financial year of farm business data is used in simulations.
\item \var{<climate year>} = Financial year of climate data is used in simulations.
\item \var{<price year>} = Financial year of output and input prices used in simulations.
\item \var{<technology year>} = Financial year of farm 'technology' (equal to farm year in all simulations)
Here financial years are referred to by the closing calendar year
(\emph{e.g.}, 2022 = 1 July 2021 to 30 June 2022).
}

-- Taken from  \cite{Australian Bureau of Agricultural and Resource
Economics and Sciences (2024)}
}

\section{Data layers}{


The data layers from the downloaded NetCDF files are described in Table 2
as seen in \cite{Australian Bureau of Agricultural and Resource Economics
and Sciences (2024)}.

Following is a copy of Table 2 for your convenience, please refer to the full
document for all methods and metadata.

\tabular{lll}{
\strong{Layer} \tab \strong{Unit} \tab \strong{Description} \cr
farmno                \tab -         \tab Row index and column index of the grid cell in the form of YYYXXX                                            \cr
A_barley_hat_ha       \tab -         \tab Proportion of total farm area planted to barley                                                              \cr
A_oilseeds_hat_ha     \tab -         \tab Proportion of total farm area planted to canola                                                              \cr
A_sorghum_hat_ha      \tab -         \tab Proportion of total farm area planted to sorghum                                                             \cr
A_total_cropped_ha    \tab -         \tab Proportion of total farm area planted to crops                                                               \cr
A_wheat_hat_ha        \tab -         \tab Proportion of total farm area planted to wheat                                                               \cr
C_chem_hat_ha         \tab $/ha      \tab Expenditure on crop and pasture chemicals per hectare                                                        \cr
C_fert_hat_ha         \tab $/ha      \tab Expenditure on fertiliser per hectare                                                                        \cr
C_fodder_hat_ha       \tab $/ha      \tab Expenditure on fodder per hectare                                                                            \cr
C_fuel_hat_ha         \tab $/ha      \tab Expenditure on fuel, oil and grease per hectare                                                              \cr
C_total_hat_ha        \tab $/ha      \tab Total cash costs per hectare                                                                                 \cr
FBP_fci_hat_ha        \tab $/ha      \tab Farm cash income per hectare                                                                                 \cr
FBP_fbp_hat_ha        \tab $/ha      \tab Farm business profit per hectare, cash income adjusted for family labour, depreciation, and changes in stocks\cr
FBP_pfe_hat_ha        \tab $/ha      \tab Profit at full equity per hectare                                                                            \cr
H_barley_dot_hat      \tab t/ha      \tab Barley yield (production per hectare planted)                                                                \cr
H_oilseeds_dot_hat    \tab t/ha      \tab Oilseeds yield (production per hectare planted)                                                              \cr
H_sorghum_dot_hat     \tab t/ha      \tab Sorghum yield (production per hectare planted)                                                               \cr
H_wheat_dot_hat       \tab t/ha      \tab Wheat yield (production per hectare planted)                                                                 \cr
Q_barley_hat_ha       \tab t/ha      \tab Barley sold per hectare (total farm area)                                                                    \cr
Q_beef_hat_ha         \tab Number/ha \tab Beef number sold per hectare                                                                                 \cr
Q_lamb_hat_ha         \tab Number/ha \tab Prime lamb number sold per hectare                                                                           \cr
Q_oilseeds_hat_ha     \tab t/ha      \tab Canola sold per hectare (total farm area)                                                                    \cr
Q_sheep_hat_ha        \tab Number/ha \tab Sheep number sold per hectare                                                                                \cr
Q_sorghum_hat_ha      \tab t/ha      \tab Sorghum sold per hectare (total farm area)                                                                   \cr
Q_wheat_hat_ha        \tab t/ha      \tab Wheat sold per hectare (total farm area)                                                                     \cr
R_barley_hat_ha       \tab $/ha      \tab Barley gross receipts per hectare                                                                            \cr
R_beef_hat_ha         \tab $/ha      \tab Beef cattle receipts per hectare                                                                             \cr
R_lamb_hat_ha         \tab $/ha      \tab Prime lamb net receipts per hectare                                                                          \cr
R_oilseeds_hat_ha     \tab $/ha      \tab Receipts for oilseeds this FY for oilseeds sold this FY or in previous FYs per hectare                       \cr
R_sheep_hat_ha        \tab $/ha      \tab Sheep gross receipts per hectare                                                                             \cr
R_sorghum_hat_ha      \tab $/ha      \tab Sorghum gross receipts per hectare                                                                           \cr
R_total_hat_ha        \tab $/ha      \tab Total farm receipts per hectare                                                                              \cr
R_wheat_hat_ha        \tab $/ha      \tab Wheat gross receipts per hectare                                                                             \cr
S_beef_births_hat_ha  \tab Number/ha \tab Beef cattle births per hectare                                                                               \cr
S_beef_cl_hat_ha      \tab Number/ha \tab Beef cattle on hand per hectare on 30 June                                                                   \cr
S_beef_deaths_hat_ha  \tab Number/ha \tab Beef cattle deaths per hectare                                                                               \cr
S_sheep_births_hat_ha \tab Number/ha \tab Sheep births per hectare                                                                                     \cr
S_sheep_cl_hat_ha     \tab Number/ha \tab Sheep on hand per hectare on 30 June                                                                         \cr
S_sheep_deaths_hat_ha \tab Number/ha \tab Sheep deaths per hectare                                                                                     \cr
S_wheat_cl_hat_ha     \tab t/ha      \tab Wheat on hand per hectare on 30 June                                                                         \cr
farmland_per_cell     \tab ha        \tab Indicative area of farmland in the grid cell
}
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}

agfd_stars <- read_agfd_stars()

head(agfd_stars)

plot(agfd_stars[[1]])
\dontshow{\}) # examplesIf}
}
\references{
\emph{Australian gridded farm data}, Australian Bureau of Agricultural and
Resource Economics and Sciences, Canberra, July 2024,
\doi{10.25814/7n6z-ev41}.
\href{https://creativecommons.org/licenses/by/4.0/legalcode}{CC BY 4.0}.

N. Hughes, W.Y. Soh, C. Boult, K. Lawson, \emph{Defining drought from
the perspective of Australian farmers}, Climate Risk Management, Volume 35,
2022, 100420, ISSN 2212-0963, \doi{10.1016/j.crm.2022.100420}.
}
\seealso{
Other AGFD: 
\code{\link{read_agfd_dt}()},
\code{\link{read_agfd_terra}()},
\code{\link{read_agfd_tidync}()}
}
\concept{AGFD}
