% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_clum_commodities.R
\name{read_clum_commodities}
\alias{read_clum_commodities}
\title{Read ABARES' Catchment Scale "Land Use of Australia" Commodities Shapefile}
\source{
\doi{10.25814/zfjz-jt75}
}
\usage{
read_clum_commodities(x = NULL)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
An \code{\link[sf:sf]{sf::sf()}} object.
}
\description{
Download (if desired) catchment level land use commodity data shapefile and
import it into your active \R session after correcting invalid geometries.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
clum_commodities <- read_clum_commodities()

clum_commodities
\dontshow{\}) # examplesIf}
}
\references{
ABARES 2024, Catchment Scale Land Use of Australia – Update December 2023
version 2, Australian Bureau of Agricultural and Resource Economics and
Sciences, Canberra, June, CC BY 4.0, DOI: \doi{10.25814/2w2p-ph98}.
}
