% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{SpecialCharacters}
\alias{SpecialCharacters}
\alias{BACKSLASH}
\alias{CARET}
\alias{DOLLAR}
\alias{DOT}
\alias{PIPE}
\alias{QUESTION}
\alias{STAR}
\alias{PLUS}
\alias{OPEN_PAREN}
\alias{CLOSE_PAREN}
\alias{OPEN_BRACKET}
\alias{CLOSE_BRACKET}
\alias{OPEN_BRACE}
\title{Special characters}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
BACKSLASH

CARET

DOLLAR

DOT

PIPE

QUESTION

STAR

PLUS

OPEN_PAREN

CLOSE_PAREN

OPEN_BRACKET

CLOSE_BRACKET

OPEN_BRACE
}
\description{
Constants to match special characters.
}
\examples{
BACKSLASH
CARET
DOLLAR
DOT
PIPE
QUESTION
STAR
PLUS
OPEN_PAREN
CLOSE_PAREN
OPEN_BRACKET
CLOSE_BRACKET
OPEN_BRACE

# Usage
x <- "\\\\^$."
rx <- BACKSLASH \%R\% CARET \%R\% DOLLAR \%R\% DOT
stringi::stri_detect_regex(x, rx)
# No escapes - these chars have special meaning inside regex
stringi::stri_detect_regex(x, x)

# Usually closing brackets can be matched without escaping
stringi::stri_detect_regex("]", "]")
# If you want to match a closing bracket inside a character class
# the closing bracket must be placed first
(rx <- char_class("]a"))
stringi::stri_detect_regex("]", rx)
# ICU and Perl also allows you to place the closing bracket in
# other positions if you escape it
(rx <- char_class("a", CLOSE_BRACKET))
stringi::stri_detect_regex("]", rx)
grepl(rx, "]", perl = TRUE)
# PCRE does not allow this
grepl(rx, "]")
}
\references{
\url{http://www.regular-expressions.info/characters.html}
}
\seealso{
\code{\link{escape_special}} for the functional form,
\code{\link{CharacterClasses}} for regex metacharacters,
\code{\link{Anchors}} for constants to match the start/end of a string,
\code{\link{WordBoundaries}} for contants to match the start/end of a word.
}
\keyword{datasets}
