% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicode-operators.R
\name{UnicodeOperators}
\alias{UnicodeOperators}
\alias{unicode_operators}
\alias{unicode_inverse}
\alias{unicode_union}
\alias{unicode_intersect}
\alias{unicode_setdiff}
\title{Unicode Pattern Operators}
\usage{
unicode_inverse(x, char_class = TRUE)

unicode_union(..., char_class = TRUE)

unicode_intersect(x, y, char_class = TRUE)

unicode_setdiff(x, y, char_class = TRUE)
}
\arguments{
\item{x}{A character vector containing Unicode General Category or Unicode 
Properties. Use the functional forms (\code{ugc_*()}) not the constants.}

\item{char_class}{\code{TRUE} or \code{FALSE}. Should the values be wrapped
into a character class?}

\item{...}{Character vectors containing Unicode General Category or Unicode 
Properties. Use the functional forms (\code{ugc_*()}) not the constants.}

\item{y}{A character vector containing Unicode General Category or Unicode 
Properties. Use the functional forms (\code{ugc_*()}) not the constants.}
}
\description{
Manipulate and combine Unicode Properties.
}
\note{
Use these with ICU-based regular expression engines (\code{stringi} and
\code{stringr}).
}
\examples{
# POSIX [:punct:] is more or less equivalent to the union of
# Unicode punctuation and symbol general categories
unicode_union(ugc_punctuation(), ugc_symbol())

# Everything except "A" to "Z" (including punctuation, control chars etc.)
unicode_inverse("[A-Z]")

# Uppercase letters, except "A" to "Z"
unicode_setdiff(ugc_uppercase_letter(), "[A-Z]")

# "A" to "F" (in upper or lower case)
unicode_intersect(ugc_letter(), up_ascii_hex_digit())

# Usage
x <- c(letters, LETTERS)
rx <- unicode_intersect(ugc_letter(), up_ascii_hex_digit())
stringi::stri_extract_first_regex(x, rx)
}
\references{
\url{http://userguide.icu-project.org/strings/unicodeset}
}
