
cache_env <- rlang::new_environment()

# Determină și salvează în 'cache_env', profesorii care au ore proprii dar
# nu și ore în cuplaje, precum și (dacă este cazul) o listă care leagă
# membrii cuplajelor (dacă au și ore proprii) de cuplajele respective.
# Pe unele discipline (la care nu există cuplaje) s-ar putea să fie mai mult
# de 9 profesori, deci 'prof' ar avea 4 caractere ('Ro12', 'Mt10'), nu 3... 

set_prof1_tw1 <- function(DZ) {
    Prof <- DZ$prof %>% unique() %>% as.character()
    if(all(nchar(Prof) <= 4)) {  # ==3 (?)
        env_bind(cache_env, prof1 = Prof)
        return(invisible())
    }
    Tw1 <- lapply(Prof, function(P) if(nchar(P) == 3) {
        pp <- setdiff(Prof,P)
        pp[nchar(pp) == 6 & grepl(P, pp)]
    }) %>% setNames(Prof) %>% compact()
    tw <- unlist(Tw1) %>% unique() %>% as.vector()
    env_bind(cache_env, prof1 = setdiff(Prof, tw), tw1=Tw1)
}
