% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy.R
\name{greedy}
\alias{greedy}
\title{Greedy one-to-one matching of pairs}
\usage{
greedy(
  x,
  y,
  weight,
  n = 1L,
  m = 1L,
  include_ties = FALSE,
  deduplication = FALSE
)
}
\arguments{
\item{x}{id's of lhs of pairs; converted to integer}

\item{y}{id's of rhs of pairs; converted to integer}

\item{weight}{numeric vector with weight of pair}

\item{n}{an integer. Each element of x can be linked to at most n elements of
y.}

\item{m}{an integer. Each element of y can be linked to at most m elements of
x.}

\item{include_ties}{when pairs for a given record have an equal weight, should
all pairs be included.}

\item{deduplication}{\code{x} and \code{y} refer to the same object and each
counts to the total \code{n} selected. \code{m} is ignored.}
}
\value{
A logical vector with the same length as \code{x}.
}
\description{
Greedy one-to-one matching of pairs
}
\details{
Pairs with the highest weight are selected as long a neither the lhs as the
rhs are already selected in a pair with a higher weight. When \code{include_ties}
is \code{TRUE} all pairs are included when multiple pairs for a given record have
an equal weight.
}
