% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rli.R
\name{rli.map}
\alias{rli.map}
\title{Mapping the Red List Index.}
\usage{
rli.map(spData, layers, layers2 = NULL, tree = NULL)
}
\arguments{
\item{spData}{Either a vector with species assessment categories for a single point in time or a matrix with two points in time in different columns (species x date). Values can be text (EX, EW, RE, CR, EN, VU, NT, DD, LC) or numeric (0 for LC, 1 for NT, 2 for VU, 3 for EN, 4 for CR, 5 for RE/EW/EX).}

\item{layers}{Species distributions (0/1), a Raster* object as defined by package raster.}

\item{layers2}{Species distributions (0/1) on the second point in time, a Raster* object as defined by package raster. If there are two dates but no layers2, the distributions are assumed to be kept constant in time.}

\item{tree}{An hclust or phylo object (used when species are weighted by their unique contribution to phylogenetic or functional diversity).}
}
\value{
A RasterLayer with point values  (if a single date is given) or change per cell (if two dates are given).
}
\description{
Creates a map for the red list index according to species distribution and threat status.
}
\details{
The IUCN Red List Index (RLI) (Butchart et al. 2004, 2007) reflects overall changes in IUCN Red List status over time of a group of taxa.
The RLI uses weight scores based on the Red List status of each of the assessed species. These scores range from 0 (Least Concern) to Extinct/Extinct in the Wild (5).
Summing these scores across all species and relating them to the worst-case scenario, i.e. all species extinct, gives us an indication of how biodiversity is doing.
Each species weight can further be influenced by how much it uniquely contributes to the phylogenetic or functional diversity of the group (Cardoso et al. in prep.).
}
\examples{
sp1 <- terra::rast(matrix(c(1,1,1,0,0,0,0,0,NA), ncol = 3))
sp2 <- terra::rast(matrix(c(1,0,0,1,0,0,1,0,NA), ncol = 3))
sp3 <- terra::rast(matrix(c(1,0,0,0,0,0,0,0,NA), ncol = 3))
sp4 <- terra::rast(matrix(c(0,1,1,1,1,1,1,1,NA), ncol = 3))
layers <- c(sp1, sp2, sp3, sp4)
spData <- c("CR","EN","VU","LC")
terra::plot(rli.map(spData, layers))
}
\references{
Butchart, S.H.M., Stattersfield, A.J., Bennun, L.A., Shutes, S.M., Akcakaya, H.R., Baillie, J.E.M., Stuart, S.N., Hilton-Taylor, C. & Mace, G.M. (2004) Measuring global trends in the status of biodiversity: Red List Indices for birds. PloS Biology, 2: 2294-2304.

Butchart, S.H.M., Akcakaya, H.R., Chanson, J., Baillie, J.E.M., Collen, B., Quader, S., Turner, W.R., Amin, R., Stuart, S.N. & Hilton-Taylor, C. (2007) Improvements to the Red List index. PloS One, 2: e140.
}
