% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reda-package.R
\docType{package}
\name{reda-package}
\alias{reda}
\alias{reda-package}
\title{Recurrent Event Data Analysis}
\description{
The R package \pkg{reda} provides functions for simulating, exploring and
modeling recurrent event data.
}
\details{
The main functions are summarized as follows:
\itemize{

\item \code{simEventData}: Simulating survival, recurrent event, and
multiple event data from stochastic process point of view.

\item \code{mcf}: Estimating the mean cumulative function (MCF) from a
fitted gamma frailty model, or from a sample recurrent event data by using
the nonparametic MCF estimator (the Nelson-Aelen estimator of the cumulative
hazard function).

\item \code{mcfDiff}: Comparing two-sample MCFs by the pseudo-score tests
and estimating their difference over time.

\item \code{rateReg}: Fitting Gamma fraitly model with spline baseline rate
function.
}

See the package vignettes for more introduction and demonstration.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://wwenjie.org/reda}
  \item \url{https://github.com/wenjie2wang/reda}
  \item Report bugs at \url{https://github.com/wenjie2wang/reda/issues}
}

}
\author{
\strong{Maintainer}: Wenjie Wang \email{wang@wwenjie.org} (\href{https://orcid.org/0000-0003-0363-3180}{ORCID})

Authors:
\itemize{
  \item Haoda Fu
}

Other contributors:
\itemize{
  \item Sy Han (Steven) Chiou [contributor]
  \item Jun Yan (\href{https://orcid.org/0000-0003-4401-7296}{ORCID}) [contributor]
}

}
\keyword{internal}
