% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabPanelModule.R
\name{tabPanelModuleUI}
\alias{tabPanelModuleUI}
\title{modularized UI for creating a new tab}
\usage{
tabPanelModuleUI(
  id,
  tabTitle,
  icon = NULL,
  calls = NULL,
  helperText = NULL,
  twoPlots = FALSE,
  calls2 = NULL,
  helperText2 = NULL,
  title2 = NULL,
  brushName = NULL,
  is.plotly = FALSE
)
}
\arguments{
\item{id}{Name of module. Allows each call of this module to be uniquely identified.}

\item{tabTitle}{Title of the tab, visible in UI}

\item{icon}{Optional icon to appear on the tab. This attribute is only valid when using a tabPanel within a navbarPage.}

\item{calls}{Unevaluated expression that stores Shiny widgets (for example, a call to a sliderInput function) for the tab.}

\item{helperText}{Optional help text for the tab.}

\item{twoPlots}{defaults to FALSE, and layout is generated for one plot. If TRUE, layout is generated for two plots}

\item{calls2}{Unevaluated expression that stores Shiny widgets for the (optional) second plot}

\item{helperText2}{Optional help text for the (optional) second plot}

\item{title2}{plot title for the (optional) second plot}

\item{brushName}{character vector indicating the name of brush if you want brushing for the plot. For use in score scatterplots
for \code{plot_shiny.fpca()} and \code{plot_shiny.mfpca()}.}

\item{is.plotly}{Indicates if plots are plotly generated. Defaults to FALSE.}
}
\description{
Creates a UI tab with helptext, widgets for user input, a plot, and standardized layout. The default is to create one plot, but if the
argument 'twoPlots' is set to TRUE, then the layout allows for two plots, where each can have separate helper text and Shiny widget calls.
}
\author{
Julia Wrobel \email{julia.wrobel@cuanschutz.edu}
}
