% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\docType{class}
\name{Claims-class}
\alias{Claims-class}
\alias{show,Claims-method}
\title{Claims}
\usage{
\S4method{show}{Claims}(object)
}
\arguments{
\item{object}{The object to display}
}
\description{
An S4 class to represent Claims and Premiums for reinsurance computations.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: show method
}}

\section{Slots}{

\describe{
\item{\code{clm}}{Data.table. Claims table. Contains at least 4 columns:
\itemize{
 \item{\code{year}: year associated with the considered claim;}
 \item{\code{portfolio}: portfolio associated with the considered claim;}
 \item{\code{simulId}: simulation id of the considered claim. Useful for stochastic modelling;}
 \item{\code{amount}: amount of the considered claim.}
}}

\item{\code{prm}}{Data.table. Premiums table. Contains at least 3 columns:
\itemize{
 \item{\code{year}: year associated with the considered premium;}
 \item{\code{portfolio}: portfolio associated with the considered premium;}
 \item{\code{amount}: amount of the considered premium.}
}}

\item{\code{rns}}{Data.table. Reinstatement amount table, that only concerns excess of loss treaties. Contains at least 2 columns:
\itemize{
 \item{\code{year}: year associated with the considered reinstatements;}
 \item{\code{simulId}: simulation id of the considered reinstatement amount. Useful for stochastic modelling.}
}}

\item{\code{com}}{Data.table. Commissions amount table, that only concerns quota share treaties. Contains at least 2 columns:
\itemize{
 \item{\code{year}: year associated with the considered commission amount;}
 \item{\code{portfolio}: portfolio associated with the considered commission.}
}}

\item{\code{trt}}{Vector. List of treaties applied to the Claims object.}
}}

