% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remode.R
\name{plot.remode_result}
\alias{plot.remode_result}
\title{Plot for remode_result}
\usage{
\method{plot}{remode_result}(
  x,
  main = paste("Number of modes =", x$nr_of_modes),
  density = replace(rep(20, length(x$frequency_input_data)), x$mode_indeces, 50),
  ...
)
}
\arguments{
\item{x}{A list of class `remode_result` containing the output of the `remode` function.}

\item{main}{A character string specifying the main title of the plot. Default is "Modes = (number of modes)".}

\item{density}{A numeric vector specifying the density of shading lines, in lines per inch, for the bars. Default is 20 for non-mode bars and 50 for mode bars.}

\item{...}{Additional arguments passed to the `barplot` function.}
}
\value{
None. This function is called for its side effects.
}
\description{
The `plot.remode_result` function provides a way to visualize the output of the `remode` function using a bar plot, highlighting the identified modes by adjusting the bar density.
}
\examples{
data <- c(80, 90, 110, 70, 90)
result <- remode(data)
plot(result, xlab="This is my x-axis label", col="red", names=-2:2)

}
