% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anomalize.R
\name{anomalize}
\alias{anomalize}
\title{Create an anomaly RasterStack}
\usage{
anomalize(x, reference = NULL, ...)
}
\arguments{
\item{x}{a RasterStack}

\item{reference}{an optional RasterLayer to be used as the reference}

\item{...}{additional arguments passed to \code{\link[raster:calc]{raster::calc()}} (and, in turn,
\code{\link[raster:writeRaster]{raster::writeRaster()}}) which is used under the hood}
}
\value{
an anomaly RasterStack
}
\description{
The function creates an anomaly RasterStack either based on the
overall mean of the original stack, or a supplied reference RasterLayer.
For the creation of seasonal anomalies use \code{\link[=deseason]{deseason()}}.
}
\examples{
data(australiaGPCP)

aus_anom <- anomalize(australiaGPCP)

opar <- par(mfrow = c(1,2))
plot(australiaGPCP[[10]], main = "original")
plot(aus_anom[[10]], main = "anomalized")
par(opar)
}
\seealso{
\code{\link[=deseason]{deseason()}}, \code{\link[=denoise]{denoise()}}, \code{\link[raster:calc]{raster::calc()}}
}
